/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.cover;

import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.converters.cover.CoverExtractor;
import com.openexchange.ajax.requesthandler.converters.cover.CoverExtractorRegistry;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;

public final class CoverResultConverter
implements ResultConverter {
    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public String getOutputFormat() {
        return "cover";
    }

    @Override
    public String getInputFormat() {
        return "file";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        Object resultObject = result.getResultObject();
        if (!(resultObject instanceof IFileHolder)) {
            throw AjaxExceptionCodes.UNEXPECTED_RESULT.create(IFileHolder.class.getSimpleName(), null == resultObject ? "null" : resultObject.getClass().getSimpleName());
        }
        IFileHolder fileHolder = (IFileHolder)resultObject;
        try {
            CoverExtractorRegistry extractorRegistry = CoverExtractorRegistry.REGISTRY_REFERENCE.get();
            if (null == extractorRegistry) {
                throw AjaxExceptionCodes.UNSUPPORTED_FORMAT.create(this.getOutputFormat());
            }
            CoverExtractor extractor = null;
            for (CoverExtractor cur : extractorRegistry.getExtractors()) {
                if (!cur.handlesFile(fileHolder)) continue;
                extractor = cur;
                break;
            }
            if (null == extractor) {
                throw AjaxExceptionCodes.UNSUPPORTED_FORMAT.create(this.getOutputFormat());
            }
            result.setResultObject(extractor.extractCover(fileHolder), this.getOutputFormat());
        }
        finally {
            Streams.close((Closeable)fileHolder);
        }
    }
}

