/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXStateHandler;
import com.openexchange.exception.OXException;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.LoggerFactory;

public final class AJAXState {
    private static final Object PRESENT = new Object();
    private final ConcurrentMap<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, Object> initializers = new ConcurrentHashMap<String, Object>();
    private final Queue<AJAXStateHandler> handlers = new ConcurrentLinkedQueue<AJAXStateHandler>();

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public <V> V optProperty(String name) {
        return this.properties.get(name);
    }

    public <V> V getProperty(String name) throws OXException {
        Object value = this.properties.get(name);
        if (null == value) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return value;
    }

    public <V> V putProperty(String name, V value) {
        return (V)this.properties.putIfAbsent(name, value);
    }

    public <V> V removeProperty(String name) {
        return this.properties.remove(name);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Set<String> propertyNames() {
        return new HashSet<String>(this.properties.keySet());
    }

    public boolean addInitializer(String identifier, AJAXStateHandler handler) {
        this.handlers.add(handler);
        return null == this.initializers.putIfAbsent(identifier, PRESENT);
    }

    public void close() {
        AJAXStateHandler handler;
        while ((handler = this.handlers.poll()) != null) {
            try {
                handler.cleanUp(this);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(AJAXState.class).error("Failed closing handler: {}", (Object)handler.getClass().getName(), (Object)e);
            }
        }
        this.initializers.clear();
        this.properties.clear();
    }
}

