/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.redirect;

import com.openexchange.ajax.AJAXUtility;
import com.openexchange.tools.servlet.http.Tools;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RedirectServlet
extends HttpServlet {
    private static final long serialVersionUID = 6111473866164506367L;
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("^(\\w*:)?//");
    private static final Pattern HOST_PATTERN = Pattern.compile("^(\\w*:)?//\\w*/");

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.getSession(true);
        String location = req.getParameter("location");
        if (location == null) {
            Tools.sendErrorPage(resp, 400, "Missing \"location\" parameter");
            return;
        }
        if (!this.isRelative(location)) {
            Tools.sendErrorPage(resp, 400, "Specified location must not be absolute.");
            return;
        }
        if (this.isServerRelative(location)) {
            resp.sendRedirect(AJAXUtility.encodeUrl(location, true));
            return;
        }
        String referer = this.purgeHost(req.getHeader("referer"));
        if (referer == null) {
            Tools.sendErrorPage(resp, 400, "Missing \"referer\" header");
            return;
        }
        location = this.assumeRelative(referer, location);
        resp.sendRedirect(AJAXUtility.encodeUrl(location, true, true));
    }

    private boolean isRelative(String location) {
        Matcher matcher = PROTOCOL_PATTERN.matcher(location);
        return !matcher.find();
    }

    private String purgeHost(String location) {
        if (location == null) {
            return null;
        }
        return HOST_PATTERN.matcher(location).replaceAll("");
    }

    private boolean isServerRelative(String location) {
        return location.length() > 0 && location.charAt(0) == '/';
    }

    private String assumeRelative(String referer, String location) {
        int index = referer.lastIndexOf(47);
        if (index >= 0) {
            return "/" + referer.substring(0, index) + "/" + location;
        }
        return "/" + referer + "/" + location;
    }
}

