/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login.session;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.SessionServletInterceptor;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.exception.OXException;
import com.openexchange.session.PutIfAbsent;
import com.openexchange.session.Session;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieRefresher
implements SessionServletInterceptor {
    private static final String PARAM_COOKIE_REFRESH_TIMESTAMP = Session.PARAM_COOKIE_REFRESH_TIMESTAMP;
    private static final String PARAM_REFRESH_SESSION_COOKIE_FLAG = "as";
    private final LoginConfiguration conf;

    public CookieRefresher(LoginConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void intercept(Session session, HttpServletRequest req, HttpServletResponse resp) throws OXException {
        if (this.needsCookieRefresh(session)) {
            String hash = session.getHash();
            LoginServlet.writeSecretCookie(req, resp, session, hash, req.isSecure(), req.getServerName(), this.conf);
            req.getSession();
        } else if (this.conf.isSessiondAutoLogin() && this.needsSessionCookieRefresh(session)) {
            String hash = session.getHash();
            if (this.refreshSessionCookie(session.getSessionID(), LoginServlet.SESSION_PREFIX + hash, req)) {
                LoginServlet.writeSessionCookie(resp, session, hash, req.isSecure(), req.getServerName());
            }
        }
    }

    private boolean refreshSessionCookie(String sessionId, String expectedSessionCookieName, HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (null == cookies || 0 == cookies.length) {
            return false;
        }
        int i = cookies.length;
        while (i-- > 0) {
            Cookie cookie = cookies[i];
            if (!expectedSessionCookieName.equals(cookie.getName()) || !sessionId.equals(cookie.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean needsCookieRefresh(Session session) {
        Long stamp = (Long)session.getParameter(PARAM_COOKIE_REFRESH_TIMESTAMP);
        if (null == stamp) {
            if (session instanceof PutIfAbsent) {
                ((PutIfAbsent)session).setParameterIfAbsent(PARAM_COOKIE_REFRESH_TIMESTAMP, (Object)System.currentTimeMillis());
            } else {
                session.setParameter(PARAM_COOKIE_REFRESH_TIMESTAMP, (Object)System.currentTimeMillis());
            }
            return false;
        }
        int intervalMillis = this.conf.getCookieExpiry() / 7 * 1000;
        long now = System.currentTimeMillis();
        if (now - (long)intervalMillis > stamp) {
            if (session instanceof PutIfAbsent) {
                if (null == ((PutIfAbsent)session).setParameterIfAbsent(PARAM_COOKIE_REFRESH_TIMESTAMP, (Object)System.currentTimeMillis())) {
                    if (this.conf.isSessiondAutoLogin()) {
                        session.setParameter(PARAM_REFRESH_SESSION_COOKIE_FLAG, (Object)Boolean.TRUE);
                    }
                    return true;
                }
            } else {
                session.setParameter(PARAM_COOKIE_REFRESH_TIMESTAMP, (Object)System.currentTimeMillis());
                if (this.conf.isSessiondAutoLogin()) {
                    session.setParameter(PARAM_REFRESH_SESSION_COOKIE_FLAG, (Object)Boolean.TRUE);
                }
                return true;
            }
        }
        return false;
    }

    private boolean needsSessionCookieRefresh(Session session) {
        Boolean flag = (Boolean)session.getParameter(PARAM_REFRESH_SESSION_COOKIE_FLAG);
        if (null == flag || !flag.booleanValue()) {
            return false;
        }
        session.setParameter(PARAM_REFRESH_SESSION_COOKIE_FLAG, null);
        if (session instanceof PutIfAbsent) {
            return null == ((PutIfAbsent)session).setParameterIfAbsent(PARAM_REFRESH_SESSION_COOKIE_FLAG, (Object)Boolean.TRUE);
        }
        session.setParameter(PARAM_REFRESH_SESSION_COOKIE_FLAG, (Object)Boolean.TRUE);
        return true;
    }
}

