/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.config.ConfigTools;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.configuration.InitProperty;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.share.GuestInfo;
import java.util.Date;

public class ShareLoginConfiguration {
    private Boolean shareAutoLogin;
    private String shareClientName;
    private String shareClientVersion;
    private Integer shareCookieTTL;
    private boolean shareTransientSessions;

    public ShareLoginConfiguration(Boolean shareAutoLogin, String shareClientName, String shareClientVersion, Integer shareCookieTTL, boolean shareTransientSessions) {
        this.reinitialise(shareAutoLogin, shareClientName, shareClientVersion, shareCookieTTL, shareTransientSessions);
    }

    public ShareLoginConfiguration(ConfigurationService configService) throws OXException {
        this.reinitialise(configService);
    }

    public LoginConfiguration getLoginConfig(GuestInfo guest) throws OXException {
        return ShareLoginConfiguration.adjustCookieTTL(this.getLoginConfig(), guest);
    }

    public LoginConfiguration getLoginConfig() throws OXException {
        LoginConfiguration defaultConfig = LoginServlet.getLoginConfiguration();
        if (null == defaultConfig) {
            throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create("no default login configuration available");
        }
        return this.getLoginConfig(defaultConfig);
    }

    public LoginConfiguration getLoginConfig(LoginConfiguration defaultConfig) {
        return new LoginConfiguration(defaultConfig.getUiWebPath(), null != this.shareAutoLogin ? this.shareAutoLogin.booleanValue() : defaultConfig.isSessiondAutoLogin(), defaultConfig.getHashSource(), defaultConfig.getHttpAuthAutoLogin(), null != this.shareClientName ? this.shareClientName : defaultConfig.getDefaultClient(), null != this.shareClientVersion ? this.shareClientVersion : defaultConfig.getClientVersion(), defaultConfig.getErrorPageTemplate(), null != this.shareCookieTTL ? this.shareCookieTTL.intValue() : defaultConfig.getCookieExpiry(), defaultConfig.isCookieForceHTTPS(), defaultConfig.isInsecure(), defaultConfig.isIpCheck(), defaultConfig.getIpCheckWhitelist(), defaultConfig.isRedirectIPChangeAllowed(), defaultConfig.getRanges(), defaultConfig.isDisableTrimLogin(), defaultConfig.isFormLoginWithoutAuthId(), defaultConfig.isRandomTokenEnabled());
    }

    public boolean isTransientShareSessions() {
        return this.shareTransientSessions;
    }

    private void reinitialise(Boolean shareAutoLogin, String shareClientName, String shareClientVersion, Integer shareCookieTTL, boolean shareTransientSessions) {
        this.shareAutoLogin = shareAutoLogin;
        this.shareClientName = shareClientName;
        this.shareClientVersion = shareClientVersion;
        this.shareCookieTTL = shareCookieTTL;
        this.shareTransientSessions = shareTransientSessions;
    }

    private void reinitialise(ConfigurationService configService) throws OXException {
        String shareAutoLoginValue = configService.getProperty(ShareLoginProperty.AUTO_LOGIN.getPropertyName());
        Boolean shareAutoLogin = Strings.isEmpty((String)shareAutoLoginValue) ? null : Boolean.valueOf(shareAutoLoginValue);
        String shareClientName = configService.getProperty(ShareLoginProperty.CLIENT_NAME.getPropertyName(), ShareLoginProperty.CLIENT_NAME.getDefaultValue());
        String shareClientVersion = configService.getProperty(ShareLoginProperty.CLIENT_VERSION.getPropertyName(), ShareLoginProperty.CLIENT_VERSION.getDefaultValue());
        String shareCookieTTLValue = configService.getProperty(ShareLoginProperty.COOKIE_TTL.getPropertyName());
        Integer shareCookieTTL = Strings.isEmpty((String)shareCookieTTLValue) ? null : Integer.valueOf(ConfigTools.parseTimespanSecs((String)shareCookieTTLValue));
        boolean shareTransientSessions = configService.getBoolProperty(ShareLoginProperty.TRANSIENT_SESSIONS.getPropertyName(), Boolean.valueOf(ShareLoginProperty.TRANSIENT_SESSIONS.getDefaultValue()).booleanValue());
        this.reinitialise(shareAutoLogin, shareClientName, shareClientVersion, shareCookieTTL, shareTransientSessions);
    }

    private static LoginConfiguration adjustCookieTTL(LoginConfiguration loginConfig, GuestInfo guest) {
        int shareExpiry;
        Date effectiveExpiry = guest.getExpiryDate();
        if (null != effectiveExpiry && 0 <= (shareExpiry = (int)((effectiveExpiry.getTime() - System.currentTimeMillis()) / 1000L)) && loginConfig.getCookieExpiry() > shareExpiry) {
            return new LoginConfiguration(loginConfig.getUiWebPath(), loginConfig.isSessiondAutoLogin(), loginConfig.getHashSource(), loginConfig.getHttpAuthAutoLogin(), loginConfig.getDefaultClient(), loginConfig.getClientVersion(), loginConfig.getErrorPageTemplate(), shareExpiry, loginConfig.isCookieForceHTTPS(), loginConfig.isInsecure(), loginConfig.isIpCheck(), loginConfig.getIpCheckWhitelist(), loginConfig.isRedirectIPChangeAllowed(), loginConfig.getRanges(), loginConfig.isDisableTrimLogin(), loginConfig.isFormLoginWithoutAuthId(), loginConfig.isRandomTokenEnabled());
        }
        return loginConfig;
    }

    public static enum ShareLoginProperty implements InitProperty
    {
        AUTO_LOGIN("com.openexchange.share.autoLogin", null),
        CLIENT_NAME("com.openexchange.share.clientName", "open-xchange-appsuite"),
        CLIENT_VERSION("com.openexchange.share.clientVersion", "Share"),
        COOKIE_TTL("com.openexchange.share.cookieTTL", "-1"),
        TRANSIENT_SESSIONS("com.openexchange.share.transientSessions", "true");

        private final String propertyName;
        private final String defaultValue;

        private ShareLoginProperty(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

