/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.customizer.folder;

import com.openexchange.ajax.customizer.AdditionalFieldsUtils;
import com.openexchange.ajax.customizer.folder.AdditionalFolderField;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalFolderFieldList {
    private static final Logger LOG = LoggerFactory.getLogger(AdditionalFolderFieldList.class);
    private final TIntObjectHashMap<AdditionalFolderField> byColId = new TIntObjectHashMap();
    private final Map<String, AdditionalFolderField> byName = new HashMap<String, AdditionalFolderField>();

    public synchronized void addField(AdditionalFolderField field) {
        int key = field.getColumnID();
        if (this.byColId.containsKey(key) || this.byName.containsKey(field.getColumnName())) {
            this.warnAboutCollision(field);
            return;
        }
        this.byColId.put(key, (Object)field);
        this.byName.put(field.getColumnName(), field);
    }

    private void warnAboutCollision(AdditionalFolderField field) {
        LOG.warn("Collision in folder fields. Field '{}' : {} has already been taken. Ignoring second service.", (Object)field.getColumnName(), (Object)field.getColumnID());
    }

    public AdditionalFolderField get(int col) {
        AdditionalFolderField additionalFolderField = (AdditionalFolderField)this.byColId.get(col);
        return null == additionalFolderField ? new NullField(col) : additionalFolderField;
    }

    public int[] getKnownFields() {
        return this.byColId.keys();
    }

    public AdditionalFolderField get(String col) {
        return this.byName.get(col);
    }

    public boolean knows(int col) {
        return this.byColId.containsKey(col);
    }

    public boolean knows(String col) {
        return this.byName.containsKey(col);
    }

    public synchronized void remove(int colId) {
        if (!this.knows(colId)) {
            return;
        }
        AdditionalFolderField f = this.get(colId);
        this.byName.remove(f.getColumnName());
        this.byColId.remove(colId);
    }

    private static final class NullField
    implements AdditionalFolderField {
        private final int columnId;

        NullField(int columnId) {
            this.columnId = columnId;
        }

        @Override
        public int getColumnID() {
            return this.columnId;
        }

        @Override
        public String getColumnName() {
            return null;
        }

        @Override
        public Object getValue(FolderObject folder, ServerSession session) {
            return null;
        }

        @Override
        public Object renderJSON(AJAXRequestData requestData, Object value) {
            return null;
        }

        @Override
        public List<Object> getValues(List<FolderObject> folder, ServerSession session) {
            return AdditionalFieldsUtils.bulk(this, folder, session);
        }
    }
}

