/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.continuation;

import com.openexchange.ajax.continuation.Continuation;
import com.openexchange.ajax.continuation.ContinuationResponse;
import com.openexchange.exception.OXException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class ExecutorContinuation<V>
implements Continuation<Collection<V>> {
    private final UUID uuid;
    private final Executor executor;
    private final BlockingQueue<Future<V>> completionQueue;
    private final List<Future<V>> completedFutures;
    private int count;
    private final String format;
    private final int hash;

    public ExecutorContinuation(Executor executor, String format) {
        this.format = null == format ? "json" : format;
        this.executor = executor;
        this.uuid = UUID.randomUUID();
        this.completionQueue = new LinkedBlockingQueue<Future<V>>();
        this.completedFutures = new LinkedList<Future<V>>();
        this.count = 0;
        int prime = 31;
        int result = 1;
        this.hash = result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public synchronized void submit(Callable<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        QueueingFuture<V> f = new QueueingFuture<V>(task, this.completionQueue);
        this.executor.execute(f);
        ++this.count;
    }

    public synchronized void submit(Runnable task, V result) {
        if (task == null) {
            throw new NullPointerException();
        }
        QueueingFuture<V> f = new QueueingFuture<V>(task, result, this.completionQueue);
        this.executor.execute(f);
        ++this.count;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public ContinuationResponse<Collection<V>> getNextResponse(long time, TimeUnit unit) throws OXException, InterruptedException {
        return this.getNextResponse(time, unit, null);
    }

    @Override
    public synchronized ContinuationResponse<Collection<V>> getNextResponse(long time, TimeUnit unit, Collection<V> defaultResponse) throws OXException, InterruptedException {
        int completedCount = this.completedFutures.size();
        if (completedCount == this.count) {
            return new ContinuationResponse<Collection<V>>(defaultResponse, true);
        }
        Future f = this.completionQueue.poll(time, unit);
        if (null == f) {
            return new ContinuationResponse<Collection<V>>(defaultResponse, false);
        }
        this.completedFutures.add(f);
        int i = this.count - ++completedCount;
        while (i-- > 0) {
            f = (Future)this.completionQueue.poll();
            if (null == f) {
                i = 0;
                continue;
            }
            this.completedFutures.add(f);
        }
        ArrayList<V> retval = new ArrayList<V>(this.completedFutures.size());
        for (Future<V> completedFuture : this.completedFutures) {
            try {
                retval.add(completedFuture.get());
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof OXException) {
                    throw (OXException)cause;
                }
                throw OXException.general((String)"Continuation failed", (Throwable)cause);
            }
        }
        return new ContinuationResponse<Collection<V>>(this.prepare(retval), false);
    }

    protected Collection<V> prepare(List<V> col) {
        return col;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Continuation)) {
            return false;
        }
        Continuation other = (Continuation)obj;
        return !(this.uuid == null ? other.getUuid() != null : !this.uuid.equals(other.getUuid()));
    }

    private static final class QueueingFuture<V>
    extends FutureTask<V> {
        private final BlockingQueue<Future<V>> queue;

        QueueingFuture(Callable<V> c, BlockingQueue<Future<V>> queue) {
            super(c);
            this.queue = queue;
        }

        QueueingFuture(Runnable t, V r, BlockingQueue<Future<V>> queue) {
            super(t, r);
            this.queue = queue;
        }

        @Override
        protected void done() {
            this.queue.add(this);
        }
    }
}

