/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.anonymizer.osgi;

import com.openexchange.ajax.anonymizer.AnonymizerRegistryService;
import com.openexchange.ajax.anonymizer.AnonymizerService;
import com.openexchange.ajax.anonymizer.Module;
import com.openexchange.ajax.anonymizer.osgi.AnonymizerChain;
import com.openexchange.exception.OXException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class OSGiAnonymizerRegistry
extends ServiceTracker<AnonymizerService<?>, AnonymizerService<?>>
implements AnonymizerRegistryService {
    private final ConcurrentMap<Module, AnonymizerChain<?>> anonymizers = new ConcurrentHashMap(8, 0.9f, 1);

    public OSGiAnonymizerRegistry(BundleContext context) {
        super(context, AnonymizerService.class.getName(), null);
    }

    public AnonymizerService<?> addingService(ServiceReference<AnonymizerService<?>> reference) {
        AnonymizerService service = (AnonymizerService)this.context.getService(reference);
        AnonymizerChain chain = (AnonymizerChain)this.anonymizers.get((Object)service.getModule());
        if (null == chain) {
            AnonymizerChain newChain = new AnonymizerChain(service.getModule());
            chain = this.anonymizers.putIfAbsent(service.getModule(), newChain);
            if (null == chain) {
                chain = newChain;
            }
        }
        if (chain.addAnonymizer(service, OSGiAnonymizerRegistry.getRanking(reference, 0))) {
            return service;
        }
        this.context.ungetService(reference);
        return null;
    }

    public void removedService(ServiceReference<AnonymizerService<?>> reference, AnonymizerService<?> service) {
        AnonymizerChain chain = (AnonymizerChain)this.anonymizers.get((Object)service.getModule());
        if (null != chain) {
            chain.removeAnonymizer(service, OSGiAnonymizerRegistry.getRanking(reference, 0));
        }
        this.context.ungetService(reference);
    }

    @Override
    public <E> AnonymizerService<E> getAnonymizerFor(String name) throws OXException {
        return this.getAnonymizerFor(Module.moduleFor(name));
    }

    @Override
    public <E> AnonymizerService<E> getAnonymizerFor(Module module) throws OXException {
        return null == module ? null : (AnonymizerService)this.anonymizers.get((Object)module);
    }

    private static <S> int getRanking(ServiceReference<S> reference, int defaultRanking) {
        int ranking = defaultRanking;
        Object oRanking = reference.getProperty("service.ranking");
        if (null != oRanking) {
            if (oRanking instanceof Integer) {
                ranking = (Integer)oRanking;
            } else {
                try {
                    ranking = Integer.parseInt(oRanking.toString().trim());
                }
                catch (NumberFormatException e) {
                    ranking = defaultRanking;
                }
            }
        }
        return ranking;
    }
}

