/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.anonymizer.osgi;

import com.openexchange.ajax.anonymizer.AnonymizerService;
import com.openexchange.ajax.anonymizer.Module;
import com.openexchange.exception.OXException;
import com.openexchange.java.SortableConcurrentList;
import com.openexchange.session.Session;

public class AnonymizerChain<E>
implements AnonymizerService<E> {
    private final SortableConcurrentList<RankedAnonymizerService<E>> anonymizers;
    private final Module module;

    public AnonymizerChain(Module module) {
        this.module = module;
        this.anonymizers = new SortableConcurrentList();
    }

    public boolean addAnonymizer(AnonymizerService<E> anonymizer, int ranking) {
        return this.anonymizers.add(new RankedAnonymizerService<E>(anonymizer, ranking));
    }

    public void removeAnonymizer(AnonymizerService<E> anonymizer, int ranking) {
        this.anonymizers.remove(new RankedAnonymizerService<E>(anonymizer, ranking));
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public E anonymize(E entity, Session session) throws OXException {
        if (null == entity) {
            return entity;
        }
        E retval = entity;
        for (RankedAnonymizerService anonymizer : this.anonymizers) {
            retval = anonymizer.anonymize(entity, session);
        }
        return retval;
    }

    private static final class RankedAnonymizerService<E>
    implements AnonymizerService<E>,
    Comparable<RankedAnonymizerService<E>> {
        private final AnonymizerService<E> anonymizer;
        private final int ranking;
        private final int hash;

        RankedAnonymizerService(AnonymizerService<E> anonymizer, int ranking) {
            this.anonymizer = anonymizer;
            this.ranking = ranking;
            int prime = 31;
            int result = 1;
            result = prime * result + (anonymizer == null ? 0 : anonymizer.hashCode());
            this.hash = result = prime * result + ranking;
        }

        @Override
        public int compareTo(RankedAnonymizerService<E> o) {
            int thisRanking = this.ranking;
            int otherRanking = o.ranking;
            return thisRanking < otherRanking ? 1 : (thisRanking == otherRanking ? 0 : -1);
        }

        @Override
        public Module getModule() {
            return this.anonymizer.getModule();
        }

        @Override
        public E anonymize(E entity, Session session) throws OXException {
            return this.anonymizer.anonymize(entity, session);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RankedAnonymizerService)) {
                return false;
            }
            RankedAnonymizerService other = (RankedAnonymizerService)obj;
            if (this.ranking != other.ranking) {
                return false;
            }
            return !(this.anonymizer == null ? other.anonymizer != null : !this.anonymizer.equals(other.anonymizer));
        }
    }
}

