/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.PermissionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.java.AllocatingStringWriter;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.java.UnsynchronizedPushbackReader;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultipleAdapterServletNew
extends PermissionServlet {
    private static final long serialVersionUID = -8060034833311074781L;
    private static final Logger LOG = LoggerFactory.getLogger(MultipleAdapterServletNew.class);
    private final AJAXActionServiceFactory factory;

    protected MultipleAdapterServletNew(AJAXActionServiceFactory factory) {
        if (null == factory) {
            throw new NullPointerException("Factory is null.");
        }
        this.factory = factory;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, false);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handle(HttpServletRequest req, HttpServletResponse resp, boolean preferStream) throws IOException, ServletException {
        resp.setStatus(200);
        resp.setContentType("text/javascript; charset=UTF-8");
        Tools.disableCaching(resp);
        String action = req.getParameter("action");
        boolean isFileUpload = Tools.isMultipartContent(req);
        ServerSession session = this.getSessionObject((ServletRequest)req);
        Response response = new Response(session);
        try {
            if (action == null) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("action");
            }
            if (this.handleIndividually(action, req, resp)) {
                return;
            }
            AJAXRequestData data = this.parseRequest(req, preferStream, isFileUpload, session, resp);
            try {
                if (this.handleIndividually(action, data, req, resp)) {
                    return;
                }
                AJAXRequestResult result = this.factory.createActionService(action).perform(data, session);
                response.setData(result.getResultObject());
                response.setTimestamp(result.getTimestamp());
                Collection<OXException> warnings = result.getWarnings();
                if (null != warnings && !warnings.isEmpty()) {
                    response.addWarnings(warnings);
                }
            }
            finally {
                if (null != data) {
                    data.cleanUploads();
                }
            }
        }
        catch (OXException e) {
            if (AjaxExceptionCodes.BAD_REQUEST.equals(e)) {
                resp.sendError(400, e.getMessage());
                return;
            }
            LOG.error("", (Throwable)e);
            response.setException(e);
        }
        catch (IllegalStateException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                OXException oxe = (OXException)cause;
                LOG.error("", (Throwable)oxe);
                response.setException(oxe);
            }
            LOG.error("", (Throwable)e);
            response.setException(AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage()));
        }
        try {
            if (isFileUpload || req.getParameter("respondWithHTML") != null && req.getParameter("respondWithHTML").equalsIgnoreCase("true")) {
                resp.setContentType("text/html; charset=UTF-8");
                String callback = req.getParameter("callback");
                if (callback == null) {
                    callback = action;
                }
                AllocatingStringWriter w = new AllocatingStringWriter();
                ResponseWriter.write(response, (Writer)w, MultipleAdapterServletNew.localeFrom(session));
                resp.getWriter().print(MultipleAdapterServletNew.substituteJS(w.toString(), callback));
            } else {
                ResponseWriter.write(response, resp.getWriter(), MultipleAdapterServletNew.localeFrom(session));
            }
        }
        catch (JSONException e) {
            OXException e1 = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error("", (Throwable)e1);
            MultipleAdapterServletNew.sendError(resp);
        }
    }

    protected boolean handleIndividually(String action, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException, OXException {
        return false;
    }

    protected boolean handleIndividually(String action, AJAXRequestData data, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException, OXException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AJAXRequestData parseRequest(HttpServletRequest req, boolean preferStream, boolean isFileUpload, ServerSession session, HttpServletResponse resp) throws IOException, OXException {
        UnsynchronizedPushbackReader reader;
        AJAXRequestData retval;
        block10: {
            retval = new AJAXRequestData().setHttpServletResponse(resp);
            retval.setUserAgent(req.getHeader("user-agent"));
            retval.setMultipart(isFileUpload);
            retval.setHttpServletRequest(req);
            retval.setSecure(Tools.considerSecure(req));
            HostnameService hostnameService = ServerServiceRegistry.getInstance().getService(HostnameService.class);
            if (null == hostnameService) {
                retval.setHostname(req.getServerName());
            } else {
                String hn = session.getUser().isGuest() ? hostnameService.getGuestHostname(session.getUserId(), session.getContextId()) : hostnameService.getHostname(session.getUserId(), session.getContextId());
                retval.setHostname(null == hn ? req.getServerName() : hn);
            }
            retval.setRemoteAddress(req.getRemoteAddr());
            retval.setRoute(Tools.getRoute(req.getSession(true).getId()));
            Set entrySet = req.getParameterMap().entrySet();
            for (Map.Entry entry : entrySet) {
                retval.putParameter((String)entry.getKey(), ((String[])entry.getValue())[0]);
            }
            if (preferStream) {
                retval.setUploadStreamProvider(new HTTPRequestInputStreamProvider(req));
                return retval;
            }
            reader = null;
            try {
                reader = new UnsynchronizedPushbackReader(AJAXServlet.getReaderFor(req));
                int read = reader.read();
                if (read < 0) {
                    retval.setData(null);
                    break block10;
                }
                char c = (char)read;
                reader.unread((int)c);
                if ('[' == c || '{' == c) {
                    try {
                        retval.setData(JSONObject.parse((Reader)reader));
                    }
                    catch (JSONException e) {
                        retval.setData(AJAXServlet.readFrom((Reader)reader));
                    }
                    break block10;
                }
                retval.setData(AJAXServlet.readFrom((Reader)reader));
            }
            catch (Throwable throwable) {
                Streams.close(reader);
                throw throwable;
            }
        }
        Streams.close((Closeable)reader);
        return retval;
    }

    private static boolean startsWith(char startingChar, String toCheck) {
        if (null == toCheck) {
            return false;
        }
        int len = toCheck.length();
        if (len <= 0) {
            return false;
        }
        int i = 0;
        if (Strings.isWhitespace((char)toCheck.charAt(i))) {
            while (++i < len && Strings.isWhitespace((char)toCheck.charAt(i))) {
            }
        }
        if (i >= len) {
            return false;
        }
        return startingChar == toCheck.charAt(i);
    }

    private static final class HTTPRequestInputStreamProvider
    implements AJAXRequestData.InputStreamProvider {
        private final HttpServletRequest req;

        HTTPRequestInputStreamProvider(HttpServletRequest req) {
            this.req = req;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.req.getInputStream();
        }
    }
}

