/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.request.AttachmentRequest;
import com.openexchange.ajax.request.FolderRequest;
import com.openexchange.ajax.request.JSONSimpleRequest;
import com.openexchange.ajax.request.MailRequest;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.Dispatchers;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.mail.MailFolderType;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.java.Strings;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.multiple.MultipleHandler;
import com.openexchange.multiple.MultipleHandlerFactoryService;
import com.openexchange.multiple.PathAware;
import com.openexchange.multiple.internal.MultipleHandlerRegistry;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.BoundedCompletionService;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.ConcurrentTIntObjectHashMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Multiple
extends SessionServlet {
    private static final long serialVersionUID = 3029074251138469122L;
    private static final transient Logger LOG = LoggerFactory.getLogger(Multiple.class);
    private static final String ACTION = "action";
    private static final String PARENT = "parent";
    protected static final String MODULE = "module";
    protected static final String MODULE_FOLDER = "folder";
    protected static final String MODULE_FOLDERS = "folders";
    private static final String ATTRIBUTE_MAIL_INTERFACE = "mi";
    private static final String ATTRIBUTE_MAIL_REQUEST = "mr";
    private static volatile Dispatcher dispatcher;
    private static final int CONCURRENCY_LEVEL = 5;
    private static final Set<String> SERIAL_MODULES;
    private static final Set<String> SERIAL_ON_MODIFICATION_MODULES;
    private static final Set<String> MODIFYING_ACTIONS;
    private static final Pattern SPLIT;
    private static final String HOSTNAME = "__hostname";
    private static final String ROUTE = "__route";
    private static final String REMOTE_ADDRESS = "__remoteAddress";
    private static final Pattern SPLIT_CSV;

    public static void setDispatcher(Dispatcher dispatcher) {
        Multiple.dispatcher = dispatcher;
    }

    private static Dispatcher getDispatcher() {
        return dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JSONArray dataArray;
        ServerSession session = this.getSessionObject((ServletRequest)req);
        if (session == null) {
            OXException e = AjaxExceptionCodes.MISSING_PARAMETER.create("session");
            e.setDisplayMessage("The request sent by the client was syntactically incorrect", new Object[0]);
            LOG.error("Missing '{}' parameter.", (Object)"session", (Object)e);
            Tools.sendErrorPage(resp, 400, e.getDisplayMessage(Locale.US));
            return;
        }
        Reader reader = AJAXServlet.getReaderFor(req);
        try {
            dataArray = new JSONArray(reader);
        }
        catch (JSONException e) {
            OXException exc = OXJSONExceptionCodes.JSON_READ_ERROR.create(e, e.getMessage());
            exc.setDisplayMessage("The request sent by the client was syntactically incorrect", new Object[0]);
            LOG.error("Received invalid JSON body in multiple request for user {} in context {} (exceptionId: {})", new Object[]{session.getUserId(), session.getContextId(), exc.getExceptionId(), e});
            Tools.sendErrorPage(resp, 400, exc.getDisplayMessage(Multiple.localeFrom(session)));
            return;
        }
        try {
            JSONArray respArr = Multiple.perform(dataArray, req, session);
            resp.setStatus(200);
            resp.setContentType("text/javascript; charset=UTF-8");
            PrintWriter writer = resp.getWriter();
            Multiple.writeTo((JSONValue)(null == respArr ? new JSONArray(0) : respArr), writer);
            ((Writer)writer).flush();
        }
        catch (JSONException e) {
            Multiple.logError("Error while writing response object.", session, (Exception)((Object)e));
            Multiple.sendError(resp);
        }
        catch (OXException e) {
            Multiple.logError("Error while writing response object.", session, (Exception)((Object)e));
            Multiple.sendError(resp);
        }
        catch (RuntimeException e) {
            Multiple.logError("Error while writing response object.", session, e);
            Multiple.sendError(resp);
        }
        finally {
            LogProperties.removeLogProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray perform(JSONArray dataArray, HttpServletRequest req, ServerSession session) throws OXException, JSONException {
        int length = dataArray.length();
        JSONArray respArr = new JSONArray(length);
        if (length > 0) {
            AJAXState state = null;
            try {
                JsonInOut jsonInOut;
                JSONObject dataObject;
                int pos;
                ArrayList<JsonInOut> serialTasks = null;
                CompletionService completionService = null;
                int concurrentTasksCount = 0;
                ConcurrentTIntObjectHashMap mapping = new ConcurrentTIntObjectHashMap(length);
                if (length > 1) {
                    for (pos = 0; pos < length; ++pos) {
                        dataObject = dataArray.getJSONObject(pos);
                        jsonInOut = new JsonInOut(pos, dataObject);
                        mapping.put(pos, (Object)jsonInOut);
                        if (!dataObject.hasAndNotNull(MODULE)) {
                            throw AjaxExceptionCodes.MISSING_PARAMETER.create(MODULE);
                        }
                        String module = dataObject.getString(MODULE);
                        if (Multiple.indicatesSerial(dataObject)) {
                            if (null == serialTasks) {
                                serialTasks = new ArrayList(length);
                            }
                            serialTasks.add(jsonInOut);
                            continue;
                        }
                        if (null == completionService) {
                            int concurrencyLevel = 5;
                            completionService = length <= 5 ? new ThreadPoolCompletionService(ThreadPools.getThreadPool()).setTrackable(true) : new BoundedCompletionService(ThreadPools.getThreadPool(), 5).setTrackable(true);
                        }
                        completionService.submit(new CallableImpl(jsonInOut, session, module, req));
                        ++concurrentTasksCount;
                    }
                } else {
                    pos = 0;
                    dataObject = dataArray.getJSONObject(0);
                    jsonInOut = new JsonInOut(0, dataObject);
                    mapping.put(0, (Object)jsonInOut);
                    if (!dataObject.hasAndNotNull(MODULE)) {
                        throw AjaxExceptionCodes.MISSING_PARAMETER.create(MODULE);
                    }
                    serialTasks = new ArrayList<JsonInOut>(1);
                    serialTasks.add(jsonInOut);
                }
                if (null != serialTasks) {
                    int size = serialTasks.size();
                    JSONArray serialResponses = new JSONArray(size);
                    for (JsonInOut jsonInOut2 : serialTasks) {
                        state = Multiple.parseActionElement(jsonInOut2.getInputObject(), serialResponses, session, req, state);
                    }
                    Multiple.writeMailRequest(req);
                    for (int i = 0; i < size; ++i) {
                        ((JsonInOut)serialTasks.get(i)).setOutputObject((JSONValue)serialResponses.get(i));
                    }
                }
                if (null != completionService) {
                    Multiple.awaitCompletionOfConcurrentTasks(completionService, concurrentTasksCount);
                }
                for (pos = 0; pos < length; ++pos) {
                    JsonInOut jsonInOut3 = (JsonInOut)mapping.get(pos);
                    if (null == jsonInOut3) continue;
                    JSONValue outputObj = jsonInOut3.getOutputObject();
                    if (null == outputObj) {
                        OXJSONWriter jsonWriter = new OXJSONWriter();
                        jsonWriter.object();
                        try {
                            ResponseWriter.writeException(OXException.general((String)("Failed to handle JSON request: " + jsonInOut3.getInputObject().toString())), jsonWriter, Multiple.localeFrom(session), false);
                        }
                        finally {
                            jsonWriter.endObject();
                        }
                        respArr.put((Object)jsonWriter.getObject());
                        continue;
                    }
                    respArr.put((Object)outputObj);
                }
            }
            finally {
                Dispatcher dispatcher;
                Multiple.close((MailServletInterface)req.getAttribute(ATTRIBUTE_MAIL_INTERFACE));
                if (state != null && null != (dispatcher = Multiple.getDispatcher())) {
                    dispatcher.end(state);
                }
            }
        }
        return respArr;
    }

    private static void awaitCompletionOfConcurrentTasks(CompletionService<Object> completionService, int concurrentTasksCount) throws OXException {
        for (int i = 0; i < concurrentTasksCount; ++i) {
            try {
                completionService.take();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static boolean indicatesSerial(JSONObject dataObject) throws JSONException {
        String module = Strings.toLowerCase((CharSequence)dataObject.getString(MODULE));
        if (null != module) {
            if (SERIAL_MODULES.contains(module)) {
                return true;
            }
            if (MODULE_FOLDERS.equals(module)) {
                String action = Strings.toLowerCase((CharSequence)dataObject.optString(ACTION, null));
                if (MODIFYING_ACTIONS.contains(action) || Multiple.isMailFolderList(action, dataObject.optString(PARENT, null))) {
                    return true;
                }
            } else if (SERIAL_ON_MODIFICATION_MODULES.contains(module)) {
                String action = Strings.toLowerCase((CharSequence)dataObject.optString(ACTION, null));
                return null != action && MODIFYING_ACTIONS.contains(action);
            }
        }
        return false;
    }

    private static boolean isMailFolderList(String action, String parentId) {
        return "list".equals(action) && MailFolderType.getInstance().servesParentId(parentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void performActionElement(JsonInOut jsonInOut, String module, ServerSession session, HttpServletRequest req) {
        AJAXState ajaxState = null;
        try {
            OXJSONWriter jWriter = new OXJSONWriter();
            JSONObject inObject = jsonInOut.getInputObject();
            ajaxState = Multiple.doAction(module, inObject.optString(ACTION), inObject, session, req, jWriter, null);
            jsonInOut.setOutputObject(jWriter.getObject());
        }
        finally {
            if (null != ajaxState) {
                ajaxState.close();
            }
        }
    }

    protected static final AJAXState parseActionElement(JSONObject inObject, JSONArray serialResponses, ServerSession session, HttpServletRequest req, AJAXState state) throws OXException {
        try {
            return Multiple.doAction(DataParser.checkString(inObject, MODULE), inObject.optString(ACTION), inObject, session, req, new OXJSONWriter(serialResponses), state);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeMailRequest(HttpServletRequest req) throws OXException {
        MailRequest mailReq = (MailRequest)req.getAttribute(ATTRIBUTE_MAIL_REQUEST);
        if (mailReq != null) {
            try {
                mailReq.performMultiple((MailServletInterface)req.getAttribute(ATTRIBUTE_MAIL_INTERFACE));
            }
            finally {
                req.setAttribute(ATTRIBUTE_MAIL_REQUEST, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static final AJAXState doAction(String module, String action, JSONObject jsonObj, ServerSession session, HttpServletRequest req, OXJSONWriter jsonWriter, AJAXState ajaxState) {
        AJAXState state = ajaxState;
        try {
            boolean handles;
            StringBuilder moduleCandidate;
            Dispatcher dispatcher;
            block55: {
                block56: {
                    block57: {
                        HostnameService hostnameService = ServerServiceRegistry.getInstance().getService(HostnameService.class);
                        if (null == hostnameService) {
                            jsonObj.put(HOSTNAME, (Object)req.getServerName());
                        } else {
                            String hn = session.getUser().isGuest() ? hostnameService.getGuestHostname(session.getUserId(), session.getContextId()) : hostnameService.getHostname(session.getUserId(), session.getContextId());
                            jsonObj.put(HOSTNAME, (Object)(null == hn ? req.getServerName() : hn));
                        }
                        jsonObj.put(ROUTE, (Object)Tools.getRoute(req.getSession(true).getId()));
                        jsonObj.put(REMOTE_ADDRESS, (Object)req.getRemoteAddr());
                        dispatcher = Multiple.getDispatcher();
                        moduleCandidate = new StringBuilder(32);
                        handles = false;
                        for (String string : SPLIT.split(module, 0)) {
                            moduleCandidate.append(string);
                            handles = dispatcher.handles(moduleCandidate.toString());
                            if (handles) break;
                            moduleCandidate.append('/');
                        }
                        if (!"mail".equals(module)) break block55;
                        if (!action.equalsIgnoreCase("update")) break block56;
                        if (!MailRequest.isMove(jsonObj)) break block57;
                        handles = false;
                        break block55;
                    }
                    if (MailRequest.isStoreFlags(jsonObj)) {
                        handles = false;
                        break block55;
                    } else if (MailRequest.isColorLabel(jsonObj)) {
                        handles = false;
                    }
                    break block55;
                }
                if (action.equalsIgnoreCase("copy")) {
                    handles = false;
                } else if (action.equalsIgnoreCase("get") && MailRequest.isCollectableGet(jsonObj)) {
                    handles = false;
                }
            }
            if (handles) {
                AJAXRequestData request = Multiple.parse(req, moduleCandidate.toString(), module.substring(moduleCandidate.length()), action, jsonObj, session, Tools.considerSecure(req));
                jsonWriter.object();
                try {
                    AJAXRequestResult result;
                    if (action == null || action.length() == 0) {
                        request.setAction("GET");
                    }
                    if (state == null) {
                        state = dispatcher.begin();
                    }
                    if ((result = dispatcher.perform(request, state, session)).getTimestamp() != null) {
                        jsonWriter.key("timestamp");
                        jsonWriter.value(result.getTimestamp().getTime());
                    }
                    jsonWriter.key("data");
                    jsonWriter.value(result.getResultObject());
                    if (null != result.getException()) {
                        boolean includeStackTraceOnError = AJAXRequestDataTools.parseBoolParameter("includeStackTraceOnError", request);
                        ResponseWriter.writeException(result.getException(), jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
                    }
                    if (null == result.getWarnings()) return state;
                    if (0 >= result.getWarnings().size()) return state;
                    ResponseWriter.writeWarnings(new ArrayList<OXException>(result.getWarnings()), jsonWriter, Multiple.localeFrom(session));
                    return state;
                }
                catch (OXException e) {
                    Multiple.logError(e.getMessage(), session, (Exception)((Object)e));
                    ResponseWriter.writeException(e, jsonWriter, Multiple.localeFrom(session), AJAXRequestDataTools.parseBoolParameter("includeStackTraceOnError", request));
                    AJAXState aJAXState = state;
                    return aJAXState;
                }
                catch (RuntimeException rte) {
                    Multiple.logError(rte.getMessage(), session, rte);
                    OXException oXException = AjaxExceptionCodes.UNEXPECTED_ERROR.create(rte, rte.getMessage());
                    ResponseWriter.writeException(oXException, jsonWriter, Multiple.localeFrom(session), AJAXRequestDataTools.parseBoolParameter("includeStackTraceOnError", request));
                    AJAXState aJAXState = state;
                    return aJAXState;
                }
                finally {
                    jsonWriter.endObject();
                }
            }
            boolean includeStackTraceOnError = jsonObj.optBoolean("includeStackTraceOnError", false);
            MultipleHandler multipleHandler = Multiple.lookUpMultipleHandler(module);
            if (null != multipleHandler) {
                try {
                    Multiple.writeMailRequest(req);
                }
                catch (OXException e) {
                    jsonWriter.object();
                    ResponseWriter.writeException(e, jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
                    jsonWriter.endObject();
                }
                jsonWriter.object();
                try {
                    Collection<OXException> warnings;
                    Object tmp = multipleHandler.performRequest(action, jsonObj, session, Tools.considerSecure(req));
                    jsonWriter.key("data");
                    jsonWriter.value(tmp);
                    Date date = multipleHandler.getTimestamp();
                    if (null != date) {
                        jsonWriter.key("timestamp").value(date.getTime());
                    }
                    if (null == (warnings = multipleHandler.getWarnings())) return state;
                    if (warnings.isEmpty()) return state;
                    ResponseWriter.writeException(warnings.iterator().next(), jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
                    return state;
                }
                catch (OXException e) {
                    if (jsonWriter.isExpectingValue()) {
                        jsonWriter.value("");
                    }
                    ResponseWriter.writeException(e, jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
                    return state;
                }
                catch (JSONException e) {
                    OXException oXException = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                    Multiple.logError(oXException.getMessage(), session, (Exception)((Object)oXException));
                    if (jsonWriter.isExpectingValue()) {
                        jsonWriter.value("");
                    }
                    ResponseWriter.writeException(oXException, jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
                    return state;
                }
                catch (RuntimeException rte) {
                    Multiple.logError(rte.getMessage(), session, rte);
                    OXException oXException = AjaxExceptionCodes.UNEXPECTED_ERROR.create(rte, rte.getMessage());
                    if (jsonWriter.isExpectingValue()) {
                        jsonWriter.value("");
                    }
                    ResponseWriter.writeException(oXException, jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
                    return state;
                }
                finally {
                    multipleHandler.close();
                    jsonWriter.endObject();
                }
            }
            if (MODULE_FOLDER.equals(module) || MODULE_FOLDERS.equals(module)) {
                try {
                    Multiple.writeMailRequest(req);
                }
                catch (OXException e) {
                    jsonWriter.object();
                    ResponseWriter.writeException(e, jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
                    jsonWriter.endObject();
                }
                FolderRequest folderequest = new FolderRequest(session, jsonWriter);
                try {
                    folderequest.action(action, jsonObj);
                    return state;
                }
                catch (OXException oXException) {
                    Multiple.logError(oXException.getMessage(), session, (Exception)((Object)oXException));
                    jsonWriter.object();
                    ResponseWriter.writeException(oXException, jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
                    jsonWriter.endObject();
                    return state;
                }
                catch (JSONException jSONException) {
                    OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(jSONException, new Object[0]);
                    Multiple.logError(oje.getMessage(), session, (Exception)((Object)oje));
                    jsonWriter.object();
                    ResponseWriter.writeException(oje, jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
                    jsonWriter.endObject();
                    return state;
                }
                catch (RuntimeException runtimeException) {
                    Multiple.logError(runtimeException.getMessage(), session, runtimeException);
                    OXException e = AjaxExceptionCodes.UNEXPECTED_ERROR.create(runtimeException, runtimeException.getMessage());
                    jsonWriter.object();
                    ResponseWriter.writeException(e, jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
                    jsonWriter.endObject();
                    return state;
                }
            }
            if ("mail".equals(module)) {
                try {
                    void var14_42;
                    MailServletInterface mi;
                    boolean storeMailRequest;
                    Object tmp = req.getAttribute(ATTRIBUTE_MAIL_REQUEST);
                    if (tmp == null) {
                        MailRequest mailRequest = new MailRequest(session, jsonWriter);
                        storeMailRequest = true;
                    } else {
                        MailRequest mailRequest = (MailRequest)tmp;
                        storeMailRequest = false;
                    }
                    tmp = req.getAttribute(ATTRIBUTE_MAIL_INTERFACE);
                    if (tmp == null) {
                        mi = MailServletInterface.getInstance(session);
                        req.setAttribute(ATTRIBUTE_MAIL_INTERFACE, (Object)mi);
                    } else {
                        mi = (MailServletInterface)tmp;
                    }
                    var14_42.action(action, jsonObj, mi);
                    if (!var14_42.isContiguousCollect()) return state;
                    if (!storeMailRequest) return state;
                    req.setAttribute(ATTRIBUTE_MAIL_REQUEST, (Object)var14_42);
                    return state;
                }
                catch (OXException e) {
                    Multiple.logError(e.getMessage(), session, (Exception)((Object)e));
                    jsonWriter.object();
                    ResponseWriter.writeException(e, jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
                    jsonWriter.endObject();
                    return state;
                }
                catch (JSONException e) {
                    OXException oXException = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                    Multiple.logError(oXException.getMessage(), session, (Exception)((Object)oXException));
                    jsonWriter.object();
                    ResponseWriter.writeException(oXException, jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
                    jsonWriter.endObject();
                    return state;
                }
            }
            if ("attachment".equals(module)) {
                AttachmentRequest request = new AttachmentRequest(session, jsonWriter);
                request.action(action, new JSONSimpleRequest(jsonObj));
                return state;
            }
            OXException oxe = AjaxExceptionCodes.UNKNOWN_MODULE.create(module);
            Multiple.logError(oxe.getMessage(), session, (Exception)((Object)oxe));
            jsonWriter.object();
            ResponseWriter.writeException(oxe, jsonWriter, Multiple.localeFrom(session), includeStackTraceOnError);
            jsonWriter.endObject();
            return state;
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
        return state;
    }

    private static AJAXRequestData parse(HttpServletRequest servletRequest, String module, String path, String action, JSONObject jsonObject, ServerSession session, boolean secure) throws JSONException {
        String parameter;
        AJAXRequestData request = new AJAXRequestData();
        request.setSecure(secure);
        if (jsonObject.hasAndNotNull("decorators") && null != (parameter = jsonObject.getString("decorators"))) {
            for (String id : SPLIT_CSV.split(parameter, 0)) {
                request.addDecoratorId(id.trim());
            }
        }
        request.setHttpServletRequest(servletRequest);
        request.setHostname(jsonObject.getString(HOSTNAME));
        request.setRoute(jsonObject.getString(ROUTE));
        request.setRemoteAddress(jsonObject.getString(REMOTE_ADDRESS));
        request.setPrefix(Dispatchers.getPrefix());
        for (Map.Entry entry : jsonObject.entrySet()) {
            String name = (String)entry.getKey();
            if ("data".equals(name)) {
                request.setData(entry.getValue());
                continue;
            }
            Object value = entry.getValue();
            if (value == null || value == JSONObject.NULL) continue;
            request.putParameter(name, entry.getValue().toString());
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        request.setModule(module);
        request.setFormat("json");
        request.setAction(action);
        request.setServletRequestURI(path);
        request.setPathInfo(path);
        request.setSession(session);
        return request;
    }

    private static MultipleHandler lookUpMultipleHandler(String module) {
        MultipleHandlerFactoryService factoryService;
        MultipleHandlerRegistry registry = ServerServiceRegistry.getInstance().getService(MultipleHandlerRegistry.class);
        if (null != registry && null != (factoryService = registry.getFactoryService(module))) {
            MultipleHandler multipleHandler = factoryService.createMultipleHandler();
            if (PathAware.class.isInstance(multipleHandler)) {
                PathAware pa = (PathAware)((Object)multipleHandler);
                pa.setPath(module.substring(factoryService.getSupportedModule().length()));
            }
            return multipleHandler;
        }
        return null;
    }

    private static void writeTo(JSONValue jValue, Writer writer) throws IOException {
        try {
            jValue.write(writer);
        }
        catch (JSONException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static void close(MailServletInterface mi) {
        if (mi != null) {
            try {
                mi.close(true);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    private static void logError(Object message, Session session, Exception e) {
        LogProperties.putSessionProperties((Session)session);
        LOG.error(message.toString(), (Throwable)e);
    }

    static {
        SERIAL_MODULES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("mail", "templating")));
        SERIAL_ON_MODIFICATION_MODULES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("calendar", "tasks", MODULE_FOLDER, MODULE_FOLDERS, "contacts")));
        MODIFYING_ACTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("delete", "new", "update")));
        SPLIT = Pattern.compile("/");
        SPLIT_CSV = Pattern.compile("\\s*,\\s*");
    }

    private static final class JsonInOut {
        private final int pos;
        private final JSONObject inObject;
        private volatile JSONValue outObject;

        protected JsonInOut(int pos, JSONObject inObject) {
            this.pos = pos;
            this.inObject = inObject;
        }

        public int getPos() {
            return this.pos;
        }

        public JSONObject getInputObject() {
            return this.inObject;
        }

        public JSONValue getOutputObject() {
            return this.outObject;
        }

        public void setOutputObject(JSONValue outObject) {
            this.outObject = outObject;
        }
    }

    private static final class CallableImpl
    implements Callable<Object> {
        private final JsonInOut jsonDataResponse;
        private final ServerSession session;
        private final String module;
        private final HttpServletRequest req;

        protected CallableImpl(JsonInOut jsonDataResponse, ServerSession session, String module, HttpServletRequest req) {
            this.jsonDataResponse = jsonDataResponse;
            this.session = session;
            this.module = module;
            this.req = req;
        }

        @Override
        public Object call() throws OXException {
            try {
                Multiple.performActionElement(this.jsonDataResponse, this.module, this.session, this.req);
                return null;
            }
            catch (RuntimeException e) {
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
    }
}

