/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.sql;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tx.ConfigurableDBProvider;
import com.openexchange.java.Streams;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public abstract class SQLTestCase
extends TestCase {
    private ConfigurableDBProvider dbProvider;
    protected Properties properties;

    public void setUp() throws Exception {
        this.loadProperties();
        this.dbProvider = new ConfigurableDBProvider();
        this.dbProvider.setDriver(this.getDriver());
        this.dbProvider.setLogin(this.getLogin());
        this.dbProvider.setPassword(this.getPassword());
        this.dbProvider.setUrl(this.getUrl());
    }

    public DBProvider getDBProvider() {
        return this.dbProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() throws IOException {
        String filename = System.getProperty("com.openexchange.test.sql.properties", "testconf/sql.properties");
        this.properties = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(filename);
            this.properties.load(input);
        }
        catch (Throwable throwable) {
            Streams.close(input);
            throw throwable;
        }
        Streams.close((Closeable)input);
    }

    public String getDriver() {
        return this.properties.getProperty("driver");
    }

    public String getLogin() {
        return this.properties.getProperty("login");
    }

    public String getPassword() {
        return this.properties.getProperty("password");
    }

    public String getUrl() {
        return this.properties.getProperty("url");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertResult(String sql) throws OXException, SQLException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDBProvider().getReadConnection(null);
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            SQLTestCase.assertTrue((String)(sql + " had no result"), (boolean)rs.next());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                this.getDBProvider().releaseReadConnection(null, con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertNoResult(String sql) throws OXException, SQLException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDBProvider().getReadConnection(null);
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            SQLTestCase.assertFalse((String)(sql + " had a result!"), (boolean)rs.next());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                this.getDBProvider().releaseReadConnection(null, con);
            }
        }
    }

    public void exec(String sql, Object ... substitutes) throws SQLException, OXException {
        this.exec(sql, Arrays.asList(substitutes));
    }

    public void exec(String sql) throws SQLException, OXException {
        this.exec(sql, new ArrayList<Object>(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(String sql, List<Object> substitues) throws SQLException, OXException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getDBProvider().getReadConnection(null);
            stmt = con.prepareStatement(sql);
            int index = 1;
            for (Object attr : substitues) {
                stmt.setObject(index++, attr);
            }
            stmt.execute();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                this.getDBProvider().releaseReadConnection(null, con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> query(String sql) throws SQLException, OXException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        LinkedList<Map<String, Object>> results = new LinkedList<Map<String, Object>>();
        try {
            con = this.getDBProvider().getReadConnection(null);
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            while (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    String key = metaData.getColumnName(i);
                    Object value = rs.getObject(i);
                    row.put(key, value);
                }
                results.add(row);
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                this.getDBProvider().releaseReadConnection(null, con);
            }
            if (rs != null) {
                rs.close();
            }
        }
        return results;
    }

    protected void copyTableStructure(String origName, String newName) throws OXException, SQLException {
        Map<String, Object> createTableRow = this.query("SHOW CREATE TABLE " + origName).get(0);
        String createStatement = (String)createTableRow.get("Create Table");
        createStatement = createStatement.replaceAll(origName, newName);
        this.exec(createStatement);
    }

    protected void dropTable(String tableName) throws OXException, SQLException {
        this.exec("DROP TABLE IF EXISTS " + tableName);
    }

    protected void insert(String tableName, Object ... attrs) throws OXException, SQLException {
        StringBuilder builder = new StringBuilder("INSERT INTO ").append(tableName).append(" (");
        StringBuilder questionMarks = new StringBuilder();
        String key = null;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object attr : attrs) {
            if (key == null) {
                key = (String)attr;
                builder.append(key).append(", ");
                continue;
            }
            values.add(attr);
            questionMarks.append("?, ");
            key = null;
        }
        builder.setLength(builder.length() - 2);
        questionMarks.setLength(questionMarks.length() - 2);
        builder.append(") VALUES (").append((CharSequence)questionMarks).append(')');
        this.exec(builder.toString(), values);
    }

    protected void assertEntry(String tableName, Object ... attrs) throws OXException, SQLException {
        StringBuilder builder = new StringBuilder("SELECT 1 FROM ").append(tableName).append(" WHERE ");
        String key = null;
        for (Object object : attrs) {
            if (key == null) {
                key = (String)object;
                continue;
            }
            builder.append(key).append(" = ").append(object);
            key = null;
        }
        this.assertResult(builder.toString());
    }
}

