/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.parser.handlers;

import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.SimContext;
import com.openexchange.groupware.ldap.SimUser;
import com.openexchange.html.HtmlService;
import com.openexchange.html.SimHtmlService;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.JsonMessageHandler;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.SimServerSession;
import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonMessageHandlerTest
extends TestCase {
    public JsonMessageHandlerTest() {
    }

    public JsonMessageHandlerTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        MimeType2ExtMap.addMimeType((String)"application/pdf", (String)"pdf");
    }

    public void testBug32692() {
        try {
            byte[] bytes = "Content-Type: multipart/alternative; boundary=\"----=_Part_8_228463983.1398448328908\"\nDate: Fri, 15 Nov 2013 04:55:25 -0800 (PST)\nFrom: \"email1@mytrial.co.uk\" <email1@mytrial.co.uk>\nTo: ho hum <email53@mytrial.co.uk>\nMessage-ID: <11574183.303149.1384520125498.chat@gmail.com>\nSubject: Chat with email1@mytrial.co.uk\nMIME-Version: 1.0\n\n------=_Part_8_228463983.1398448328908\nContent-Type: text/xml; charset=utf-8\nContent-Transfer-Encoding: 7bit\n\n<con:conversation xmlns:con=\"google:archive:conversation\">\n<cli:message to=\"email53@mytrial.co.uk\" iconset=\"classic\" from=\"email1@mytrial.co.uk\" int:cid=\"278391101870075059\" int:sequence-no=\"1\" int:time-stamp=\"1384520125480\" xmlns:cli=\"jabber:client\" xmlns:int=\"google:internal\">\n<cli:body>hi</cli:body><met:google-mail-signature xmlns:met=\"google:metadata\">2jLeBillxquvrnTPZKm8uZNifgY</met:google-mail-signature>\n<x stamp=\"20131115T12:55:25\" xmlns=\"jabber:x:delay\"/><time ms=\"1384520125498\" xmlns=\"google:timestamp\"/>\n</cli:message></con:conversation>\n\n------=_Part_8_228463983.1398448328908\nContent-Type: text/html; charset=utf-8\nContent-Transfer-Encoding: 7bit\n\nhi\n\n------=_Part_8_228463983.1398448328908--".getBytes();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])bytes);
            ServerServiceRegistry.getInstance().addService(HtmlService.class, (Object)new SimHtmlService());
            UserSettingMail usm = new UserSettingMail(1, 1);
            usm.parseBits(627479);
            SimServerSession session = new SimServerSession((Context)new SimContext(1), new SimUser(1), null);
            JsonMessageHandler handler = new JsonMessageHandler(0, "INBOX/1", DisplayMode.DISPLAY, true, (Session)session, usm, false, 0);
            MailMessageParser parser = new MailMessageParser();
            parser.parseMailMessage(mail, (MailMessageHandler)handler);
            JSONObject jMail = handler.getJSONObject();
            JsonMessageHandlerTest.assertNotNull((Object)jMail);
            JSONArray jAttachments = jMail.getJSONArray("attachments");
            JsonMessageHandlerTest.assertNotNull((Object)jAttachments);
            JsonMessageHandlerTest.assertEquals((String)"Unexpected number of attachments", (int)1, (int)jAttachments.length());
            JSONObject jAttachment1 = jAttachments.getJSONObject(0);
            JsonMessageHandlerTest.assertNotNull((Object)jAttachment1);
            JsonMessageHandlerTest.assertTrue((String)"Unexpected content", (boolean)jAttachment1.getString("content_type").startsWith("text/html"));
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonMessageHandlerTest.fail((String)e.getMessage());
        }
    }

    public void testBug32108() {
        try {
            byte[] bytes = "Delivered-To: fake@gmail.com\nDate: Sat, 19 Apr 2014 12:45:45 +0800 (MYT)\nFrom: Test User Dhamu <testoxuser10@yes1.my>\nReply-To: Test User Dhamu <testoxuser10@yes1.my>\nTo: \"fake@gmail.com\" <fake@gmail.com>\nMessage-ID: <9575168.5.1397882746309.open-xchange@SN2YCVX1C1003>\nSubject: New appointment: supertest\nMIME-Version: 1.0\nContent-Type: multipart/mixed; boundary=\"----=_Part_3_1465200755.1397882745831\"\nX-Priority: 3 (normal)\nX-Mailer: Open-Xchange Mailer v7.4.2-Rev18\nX-OX-Marker: cfeefd6b-a2bb-4c1c-b705-22f9f7bf6597\n\n------=_Part_3_1465200755.1397882745831\nContent-Type: multipart/alternative; \n    boundary=\"----=_Part_2_507915751.1397882745827\"\n\n------=_Part_2_507915751.1397882745827\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\nYou have been invited to an event by Test User Dhamu:\n\n\n\n====[       supertest       ]====\n\nAll times will be shown in the Malaysia Time time zone\n\nWhen: Saturday, 19 April 2014 13:00 - 14:00\n\n\n\n== Participants: ==\n\nTest User Dhamu (accepted)\nfake@gmail.com (waiting)\n\n== Resources ==\n\n\n== Details: ==\n\nShow as: Reserved\nCreated: Saturday, 19 April 2014 12:45 - Test User Dhamu\n\n\n\n\n\n\n\n\n------=_Part_2_507915751.1397882745827\nMIME-Version: 1.0\nContent-Type: text/html; charset=UTF-8\nContent-Transfer-Encoding: quoted-printable\n\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org=\n/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=3D\"http://www.w3.org/1999/xht=\nml\"><head>\n    <meta http-equiv=3D\"Content-Type\" content=3D\"text/html; charset=3DUTF-8=\n\" />\n =20\n  <title></title>=20\n  <meta charset=3D\"UTF-8\" />=20\n =20\n </head><body>\n =20\n  <div class=3D\"content\">=20\n   <div class=3D\"timezone\">\n     All times will be shown in the=20\n    <em>Malaysia Time</em> time zone=20\n   </div>=20\n   <div class=3D\"calendar-action\">\n    You have been invited to an event by=20\n    <span class=3D\"person\">Test User Dhamu</span>:\n   </div>=20\n   <div class=3D\"calendar-detail\">=20\n    <div class=3D\"date\">=20\n     <div class=3D\"interval\">\n       13:00 - 14:00=20\n     </div>=20\n     <div class=3D\"day\">\n       Saturday, 19 April 2014=20\n     </div>=20\n    </div>=20\n    <div class=3D\"title clear-title\">\n      supertest=20\n    </div>=20\n    <div class=3D\"location\">=20\n    </div>=20\n    <div style=3D\"display:none\" class=3D\"calendar-buttons\"></div>=20\n    <div class=3D\"note\">=20\n    </div>=20\n    <div class=3D\"participants\">=20\n     <div class=3D\"label\">\n       Participants:=20\n     </div>=20\n     <div class=3D\"participant-list\">=20\n      <div class=3D\"participant\">=20\n       <span class=3D\"person\">Test User Dhamu</span>=20\n       <span class=3D\"status accepted\">=E2=9C=93</span>=20\n       <span class=3D\"comment\"></span>=20\n      </div>=20\n      <div class=3D\"participant\">=20\n       <span class=3D\"person\">fake@gmail.com</span>=20\n       <span class=3D\"comment\"></span>=20\n      </div>=20\n     </div>=20\n     <div class=3D\"participants-clear\"></div>=20\n    </div>=20\n    <div class=3D\"participants\">=20\n     <div class=3D\"label\">\n       Resources=20\n     </div>=20\n     <div class=3D\"participant-list\">=20\n     </div>=20\n     <div class=3D\"participants-clear\"></div>=20\n    </div>=20\n    <div>=20\n     <div class=3D\"label\">\n       Details:=20\n     </div>\n     <span class=3D\"detail-label\">Show as:&#160;</span>\n     <span class=3D\"detail\"><span class=3D\"shown_as_label reserved\">Reserve=\nd</span></span>\n     <br />=20\n     <span class=3D\"detail-label\">Created:&#160;</span>\n     <span class=3D\"detail\"><span>Saturday, 19 April 2014 12:45</span> <spa=\nn>-</span> <span>Test User Dhamu</span></span>=20\n    </div>=20\n    <div class=3D\"attachmentNote\">=20\n    </div>=20\n    <div class=3D\"justification\">=20\n    </div>=20\n   </div>=20\n  </div>  =20\n=20\n</body></html>\n------=_Part_2_507915751.1397882745827\nContent-Type: text/calendar; charset=UTF-8; method=REQUEST\nContent-Transfer-Encoding: 7bit\n\nBEGIN:VCALENDAR\nPRODID:Open-Xchange\nVERSION:2.0\nCALSCALE:GREGORIAN\nMETHOD:REQUEST\nBEGIN:VTIMEZONE\nTZID:Asia/Kuala_Lumpur\nTZURL:http://tzurl.org/zoneinfo-outlook/Asia/Kuala_Lumpur\nX-LIC-LOCATION:Asia/Kuala_Lumpur\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:MYT\nDTSTART:19700101T003000\nEND:STANDARD\nEND:VTIMEZONE\nBEGIN:VEVENT\nDTSTAMP:20140419T044545Z\nSUMMARY:supertest\nDTSTART;TZID=Asia/Kuala_Lumpur:20140419T130000\nDTEND;TZID=Asia/Kuala_Lumpur:20140419T140000\nCLASS:PUBLIC\nTRANSP:OPAQUE\nUID:7213b334-f321-47c3-aacf-9f2d5aa0b2f3\nCREATED:20140419T044544Z\nLAST-MODIFIED:20140419T044544Z\nORGANIZER:mailto:testoxuser10@yes1.my\nSEQUENCE:0\nATTENDEE;ROLE=REQ-PARTICIPANT;CUTYPE=INDIVIDUAL;CN=Test User Dhamu;PARTSTAT=ACCEPTED:mailto:testoxuser10@yes1.my\nATTENDEE;CUTYPE=INDIVIDUAL;PARTSTAT=NEEDS-ACTION;ROLE=REQ-PARTICIPANT;RSVP=TRUE:mailto:fake@gmail.com\nEND:VEVENT\nEND:VCALENDAR\n\n------=_Part_2_507915751.1397882745827--\n\n------=_Part_3_1465200755.1397882745831\nContent-Type: application/ics; name=invite.ics\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment; filename=invite.ics\n\nQkVHSU46VkNBTEVOREFSDQpQUk9ESUQ6T3Blbi1YY2hhbmdlDQpWRVJTSU9OOjIuMA0KQ0FMU0NB\nTEU6R1JFR09SSUFODQpNRVRIT0Q6UkVRVUVTVA0KQkVHSU46VlRJTUVaT05FDQpUWklEOkFzaWEv\nS3VhbGFfTHVtcHVyDQpUWlVSTDpodHRwOi8vdHp1cmwub3JnL3pvbmVpbmZvLW91dGxvb2svQXNp\nYS9LdWFsYV9MdW1wdXINClgtTElDLUxPQ0FUSU9OOkFzaWEvS3VhbGFfTHVtcHVyDQpCRUdJTjpT\nVEFOREFSRA0KVFpPRkZTRVRGUk9NOiswODAwDQpUWk9GRlNFVFRPOiswODAwDQpUWk5BTUU6TVlU\nDQpEVFNUQVJUOjE5NzAwMTAxVDAwMzAwMA0KRU5EOlNUQU5EQVJEDQpFTkQ6VlRJTUVaT05FDQpC\nRUdJTjpWRVZFTlQNCkRUU1RBTVA6MjAxNDA0MTlUMDQ0NTQ1Wg0KU1VNTUFSWTpzdXBlcnRlc3QN\nCkRUU1RBUlQ7VFpJRD1Bc2lhL0t1YWxhX0x1bXB1cjoyMDE0MDQxOVQxMzAwMDANCkRURU5EO1Ra\nSUQ9QXNpYS9LdWFsYV9MdW1wdXI6MjAxNDA0MTlUMTQwMDAwDQpDTEFTUzpQVUJMSUMNClRSQU5T\nUDpPUEFRVUUNClVJRDo3MjEzYjMzNC1mMzIxLTQ3YzMtYWFjZi05ZjJkNWFhMGIyZjMNCkNSRUFU\nRUQ6MjAxNDA0MTlUMDQ0NTQ0Wg0KTEFTVC1NT0RJRklFRDoyMDE0MDQxOVQwNDQ1NDRaDQpPUkdB\nTklaRVI6bWFpbHRvOnRlc3RveHVzZXIxMEB5ZXMxLm15DQpTRVFVRU5DRTowDQpBVFRFTkRFRTtS\nT0xFPVJFUS1QQVJUSUNJUEFOVDtDVVRZUEU9SU5ESVZJRFVBTDtDTj1UZXN0IFVzZXIgRGhhbXU7\nUEFSVFNUQVQ9QUNDRVBURUQ6bWFpbHRvOnRlc3RveHVzZXIxMEB5ZXMxLm15DQpBVFRFTkRFRTtD\nVVRZUEU9SU5ESVZJRFVBTDtQQVJUU1RBVD1ORUVEUy1BQ1RJT047Uk9MRT1SRVEtUEFSVElDSVBB\nTlQ7UlNWUD1UUlVFOm1haWx0bzptYWxhc2FAZ21haWwuY29tDQpFTkQ6VkVWRU5UDQpFTkQ6VkNB\nTEVOREFSDQo=\n------=_Part_3_1465200755.1397882745831--\n".getBytes();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])bytes);
            MimeType2ExtMap.addMimeType((String)"application/pdf", (String)"pdf");
            MimeType2ExtMap.addMimeType((String)"application/rtf", (String)"rtf");
            MimeType2ExtMap.addMimeType((String)"application/ics", (String)"ics");
            ServerServiceRegistry.getInstance().addService(HtmlService.class, (Object)new SimHtmlService());
            UserSettingMail usm = new UserSettingMail(1, 1);
            usm.parseBits(627479);
            SimServerSession session = new SimServerSession((Context)new SimContext(1), new SimUser(1), null);
            JsonMessageHandler handler = new JsonMessageHandler(0, "INBOX/1", DisplayMode.DISPLAY, true, (Session)session, usm, false, 0);
            MailMessageParser parser = new MailMessageParser();
            parser.parseMailMessage(mail, (MailMessageHandler)handler);
            JSONObject jMail = handler.getJSONObject();
            JsonMessageHandlerTest.assertNotNull((Object)jMail);
            JSONArray jAttachments = jMail.getJSONArray("attachments");
            JsonMessageHandlerTest.assertNotNull((Object)jAttachments);
            JsonMessageHandlerTest.assertEquals((String)"Unexpected number of attachments", (int)3, (int)jAttachments.length());
            JSONObject jAttachment1 = jAttachments.getJSONObject(0);
            JsonMessageHandlerTest.assertNotNull((Object)jAttachment1);
            JSONObject jAttachment2 = jAttachments.getJSONObject(1);
            JsonMessageHandlerTest.assertNotNull((Object)jAttachment2);
            JSONObject jAttachment3 = jAttachments.getJSONObject(2);
            JsonMessageHandlerTest.assertNotNull((Object)jAttachment3);
            JsonMessageHandlerTest.assertTrue((String)"Unexpected content", (boolean)jAttachment1.getString("content_type").startsWith("text/html"));
            JsonMessageHandlerTest.assertTrue((String)"Unexpected content", (boolean)jAttachment2.getString("content_type").startsWith("text/calendar"));
            JsonMessageHandlerTest.assertTrue((String)"Unexpected content", (boolean)jAttachment3.getString("content_type").startsWith("application/ics"));
            JsonMessageHandlerTest.assertTrue((String)("Unexpected Content-Dispostion for " + jAttachment2.getString("id")), (boolean)jAttachment2.getString("disp").startsWith("attachment"));
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonMessageHandlerTest.fail((String)e.getMessage());
        }
    }

    public void testBug35899() {
        try {
            MailMessage mail = MimeMessageConverter.convertMessage((InputStream)new FileInputStream("./test/com/openexchange/mail/parser/handlers/tnef_oloxproblemmail.eml"));
            MimeType2ExtMap.addMimeType((String)"application/pdf", (String)"pdf");
            MimeType2ExtMap.addMimeType((String)"application/rtf", (String)"rtf");
            MimeType2ExtMap.addMimeType((String)"image/png", (String)"png");
            ServerServiceRegistry.getInstance().addService(HtmlService.class, (Object)new SimHtmlService());
            UserSettingMail usm = new UserSettingMail(1, 1);
            usm.parseBits(627479);
            SimServerSession session = new SimServerSession((Context)new SimContext(1), new SimUser(1), null);
            JsonMessageHandler handler = new JsonMessageHandler(0, "INBOX/1", DisplayMode.DISPLAY, true, (Session)session, usm, false, 0);
            MailMessageParser parser = new MailMessageParser();
            parser.parseMailMessage(mail, (MailMessageHandler)handler);
            JSONObject jMail = handler.getJSONObject();
            JsonMessageHandlerTest.assertNotNull((Object)jMail);
            JSONArray jAttachments = jMail.getJSONArray("attachments");
            JsonMessageHandlerTest.assertNotNull((Object)jAttachments);
            JsonMessageHandlerTest.assertEquals((String)"Unexpected number of attachments", (int)4, (int)jAttachments.length());
            JSONObject jAttachment1 = jAttachments.getJSONObject(0);
            JsonMessageHandlerTest.assertNotNull((Object)jAttachment1);
            JSONObject jAttachment2 = jAttachments.getJSONObject(1);
            JsonMessageHandlerTest.assertNotNull((Object)jAttachment2);
            JSONObject jAttachment3 = jAttachments.getJSONObject(2);
            JsonMessageHandlerTest.assertNotNull((Object)jAttachment3);
            JSONObject jAttachment4 = jAttachments.getJSONObject(3);
            JsonMessageHandlerTest.assertNotNull((Object)jAttachment4);
            System.out.println("------- Debug Output ------");
            System.out.println(jMail.toString(2));
            JsonMessageHandlerTest.assertTrue((String)"Unexpected content", (boolean)jAttachment1.getString("content_type").startsWith("text/plain"));
            JsonMessageHandlerTest.assertTrue((String)"Unexpected content", (boolean)jAttachment2.getString("content_type").startsWith("application/rtf"));
            JsonMessageHandlerTest.assertTrue((String)"Unexpected content", (boolean)jAttachment3.getString("content_type").startsWith("application/pdf"));
            JsonMessageHandlerTest.assertTrue((String)"Unexpected content", (boolean)jAttachment4.getString("content_type").startsWith("image/png"));
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonMessageHandlerTest.fail((String)e.getMessage());
        }
    }

    public void testBug37141() {
        try {
            MailMessage mail = MimeMessageConverter.convertMessage((InputStream)new FileInputStream("./test/com/openexchange/mail/parser/handlers/testproblem.eml"));
            MimeType2ExtMap.addMimeType((String)"application/pdf", (String)"pdf");
            MimeType2ExtMap.addMimeType((String)"application/rtf", (String)"rtf");
            MimeType2ExtMap.addMimeType((String)"image/png", (String)"png");
            ServerServiceRegistry.getInstance().addService(HtmlService.class, (Object)new SimHtmlService());
            UserSettingMail usm = new UserSettingMail(1, 1);
            usm.parseBits(627479);
            SimServerSession session = new SimServerSession((Context)new SimContext(1), new SimUser(1), null);
            JsonMessageHandler handler = new JsonMessageHandler(0, "INBOX/1", DisplayMode.DISPLAY, true, (Session)session, usm, false, 0);
            MailMessageParser parser = new MailMessageParser();
            parser.parseMailMessage(mail, (MailMessageHandler)handler);
            JSONObject jMail = handler.getJSONObject();
            JsonMessageHandlerTest.assertNotNull((Object)jMail);
            JSONArray jAttachments = jMail.getJSONArray("attachments");
            JsonMessageHandlerTest.assertNotNull((Object)jAttachments);
            JsonMessageHandlerTest.assertEquals((String)"Unexpected number of attachments", (int)2, (int)jAttachments.length());
            JSONObject jAttachment1 = jAttachments.getJSONObject(0);
            JsonMessageHandlerTest.assertNotNull((Object)jAttachment1);
            JSONObject jAttachment2 = jAttachments.getJSONObject(1);
            JsonMessageHandlerTest.assertNotNull((Object)jAttachment2);
            System.out.println("------- Debug Output ------");
            System.out.println(jMail.toString(2));
            JsonMessageHandlerTest.assertTrue((String)"Unexpected content", (boolean)jAttachment1.getString("content_type").startsWith("text/plain"));
            JsonMessageHandlerTest.assertTrue((String)"Unexpected content", (boolean)jAttachment2.getString("content_type").startsWith("application/pdf"));
            JsonMessageHandlerTest.assertTrue((String)"Unexpected message body", (jAttachment1.getString("content").indexOf("da muss ein vermutlich") > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonMessageHandlerTest.fail((String)e.getMessage());
        }
    }

    public void testBug40645() {
        try {
            MailMessage mail = MimeMessageConverter.convertMessage((InputStream)new FileInputStream("./test/com/openexchange/mail/parser/handlers/Test_PGP.eml"));
            MimeType2ExtMap.addMimeType((String)"application/pdf", (String)"pdf");
            MimeType2ExtMap.addMimeType((String)"application/rtf", (String)"rtf");
            MimeType2ExtMap.addMimeType((String)"image/png", (String)"png");
            ServerServiceRegistry.getInstance().addService(HtmlService.class, (Object)new SimHtmlService());
            UserSettingMail usm = new UserSettingMail(1, 1);
            usm.parseBits(627479);
            SimServerSession session = new SimServerSession((Context)new SimContext(1), new SimUser(1), null);
            JsonMessageHandler handler = new JsonMessageHandler(0, "INBOX/1", DisplayMode.DISPLAY, true, (Session)session, usm, false, 0);
            MailMessageParser parser = new MailMessageParser();
            parser.parseMailMessage(mail, (MailMessageHandler)handler);
            JSONObject jMail = handler.getJSONObject();
            JsonMessageHandlerTest.assertNotNull((Object)jMail);
            JSONArray jAttachments = jMail.getJSONArray("attachments");
            JsonMessageHandlerTest.assertNotNull((Object)jAttachments);
            JsonMessageHandlerTest.assertEquals((String)"Unexpected number of attachments", (int)2, (int)jAttachments.length());
            JSONObject jAttachment1 = jAttachments.getJSONObject(0);
            JsonMessageHandlerTest.assertNotNull((Object)jAttachment1);
            JSONObject jAttachment2 = jAttachments.getJSONObject(1);
            JsonMessageHandlerTest.assertNotNull((Object)jAttachment2);
            System.out.println("------- Debug Output ------");
            System.out.println(jMail.toString(2));
            JsonMessageHandlerTest.assertTrue((String)"Unexpected content", (boolean)jAttachment1.getString("content_type").startsWith("text/plain"));
            JsonMessageHandlerTest.assertTrue((String)"Unexpected content", (boolean)jAttachment2.getString("content_type").startsWith("application/pgp-signature"));
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonMessageHandlerTest.fail((String)e.getMessage());
        }
    }
}

