/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.config;

import com.openexchange.java.Strings;
import com.openexchange.mail.config.IPRange;
import java.util.LinkedList;
import junit.framework.TestCase;

public class Bug38266Test
extends TestCase {
    public void testForBug38266() {
        LinkedList<IPRange> ranges = new LinkedList<IPRange>();
        for (String range : Strings.splitByComma((String)"10.30.73.4,10.30.77.0/24,10.30.73.0/24")) {
            if (null == range) {
                System.err.println("Invalid IP range value: 'null'");
                continue;
            }
            try {
                IPRange parsedRange = IPRange.parseRange((String)range.trim());
                if (null == parsedRange) {
                    System.err.println("Invalid IP range value: " + range);
                    continue;
                }
                ranges.add(parsedRange);
            }
            catch (Exception e) {
                System.err.println("Invalid IP range value: " + range);
                e.printStackTrace(System.err);
            }
        }
        Bug38266Test.assertTrue((String)"Unexpected number of IP ranges", (ranges.size() > 0 ? 1 : 0) != 0);
        Bug38266Test.assertTrue((String)"Should be white-listed, but is not", (boolean)IPRange.isWhitelistedFromRateLimit((String)"10.30.73.4", ranges));
    }
}

