/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.groupware.userconfiguration.Permission;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class UserConfigurationTest {
    @Test
    public void testByBits_GetActiveSync_returnPermission() {
        List userPermissionsByBit = Permission.byBits((int)0x2000000);
        Assert.assertNotNull((Object)userPermissionsByBit);
    }

    @Test
    public void testByBits_GetActiveSync_returnCorrectSize() {
        List userPermissionsByBit = Permission.byBits((int)0x2000000);
        Assert.assertEquals((long)1L, (long)userPermissionsByBit.size());
    }

    @Test
    public void testByBits_NoValidBit_returnEmptyPermission() {
        List userPermissionsByBit = Permission.byBits((int)0);
        Assert.assertNotNull((Object)userPermissionsByBit);
    }

    @Test
    public void testByBits_NoValidBit_returnEmptyList() {
        List userPermissionsByBit = Permission.byBits((int)0);
        Assert.assertEquals((long)0L, (long)userPermissionsByBit.size());
    }

    @Test
    public void testByBits_GetWithThreePermissions_returnCorrectSize() {
        List userPermissionsByBit = Permission.byBits((int)0x22000002);
        Assert.assertEquals((long)3L, (long)userPermissionsByBit.size());
    }

    @Test
    public void testByBits_GetWithManyPermissions_returnList() {
        List userPermissionsByBit = Permission.byBits((int)0x200005);
        Assert.assertEquals((long)3L, (long)userPermissionsByBit.size());
    }
}

