/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.tasks.MakeFolderIdPrimaryForDelContactsTable;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Database.class, Tools.class})
public class MakeFolderIdPrimaryForDelContactsTableTest {
    @InjectMocks
    private MakeFolderIdPrimaryForDelContactsTable makeFolderIdPrimaryForDelContactsTable;
    @Mock
    private PerformParameters mockParams;
    @Mock
    private Connection mockConnection;
    int contextId = 1;

    @Before
    public void setUp() throws OXException {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(Database.class, (Class[])new Class[0]);
        PowerMockito.when((Object)Database.getNoTimeout((int)this.contextId, (boolean)true)).thenReturn((Object)this.mockConnection);
        Mockito.when((Object)this.mockParams.getContextId()).thenReturn((Object)this.contextId);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPerform_paramsNull_throwExpception() throws OXException {
        this.makeFolderIdPrimaryForDelContactsTable.perform(null);
    }

    @Test(expected=OXException.class)
    public void testPerform_connectionNotProper_throwException() throws OXException {
        this.makeFolderIdPrimaryForDelContactsTable.perform(this.mockParams);
    }

    @Test
    public void testPerform_tableHasNoPrimaryKey_createPrimaryKeyWithoutDroppingBefore() throws OXException, SQLException {
        PowerMockito.mockStatic(Tools.class, (Class[])new Class[0]);
        PowerMockito.when((Object)Tools.hasPrimaryKey((Connection)this.mockConnection, (String)"del_contacts")).thenReturn((Object)false);
        PowerMockito.when((Object)Tools.hasPrimaryKey((Connection)this.mockConnection, (String)"prg_contacts")).thenReturn((Object)false);
        this.makeFolderIdPrimaryForDelContactsTable.perform(this.mockParams);
        PowerMockito.verifyStatic((VerificationMode)Mockito.never());
        Tools.dropPrimaryKey((Connection)this.mockConnection, (String)"del_contacts");
        PowerMockito.verifyStatic((VerificationMode)Mockito.times((int)1));
        Tools.hasPrimaryKey((Connection)this.mockConnection, (String)"del_contacts");
        Tools.hasPrimaryKey((Connection)this.mockConnection, (String)"prg_contacts");
        Tools.createPrimaryKey((Connection)this.mockConnection, (String)"del_contacts", (String[])new String[]{"cid", "intfield01", "fid"});
        Tools.createPrimaryKey((Connection)this.mockConnection, (String)"prg_contacts", (String[])new String[]{"cid", "intfield01", "fid"});
    }

    @Test
    public void testPerform_tableHasNoPrimaryKey_createPrimaryKeyWithDroppingBefore() throws OXException, SQLException {
        PowerMockito.mockStatic(Tools.class, (Class[])new Class[0]);
        PowerMockito.when((Object)Tools.hasPrimaryKey((Connection)this.mockConnection, (String)"del_contacts")).thenReturn((Object)true);
        PowerMockito.when((Object)Tools.hasPrimaryKey((Connection)this.mockConnection, (String)"prg_contacts")).thenReturn((Object)true);
        this.makeFolderIdPrimaryForDelContactsTable.perform(this.mockParams);
        PowerMockito.verifyStatic((VerificationMode)Mockito.times((int)1));
        Tools.dropPrimaryKey((Connection)this.mockConnection, (String)"del_contacts");
        Tools.dropPrimaryKey((Connection)this.mockConnection, (String)"prg_contacts");
        Tools.hasPrimaryKey((Connection)this.mockConnection, (String)"del_contacts");
        Tools.hasPrimaryKey((Connection)this.mockConnection, (String)"prg_contacts");
        Tools.createPrimaryKey((Connection)this.mockConnection, (String)"del_contacts", (String[])new String[]{"cid", "intfield01", "fid"});
        Tools.createPrimaryKey((Connection)this.mockConnection, (String)"prg_contacts", (String[])new String[]{"cid", "intfield01", "fid"});
    }
}

