/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.groupware.ldap.User;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MockUser
implements User {
    private static final int GROUP_ALL = 0;
    private static final long serialVersionUID = 2265710814522924009L;
    private String givenName;
    private String surname;
    private final int id;
    private int contactId;
    private String mail;
    private String mailDomain;
    private String imapServer;
    private String imapLogin;
    private String smtpServer;
    private String timeZone;
    private int appointmentDays;
    private int taskDays;
    private String preferredLanguage;
    private String displayName;
    private String userPassword = "x";
    private boolean mailEnabled = false;
    private int shadowLastChange = -1;
    private int[] groups;
    private String passwordMech;
    private String loginInfo;
    private Locale locale;
    private int filestoreId = -1;
    private String filestoreName;
    private String[] filestorageAuth;
    private long fileStorageQuota;
    private int fileStorageOwner;
    private final Map<String, Set<String>> attributes = new HashMap<String, Set<String>>();

    public MockUser(int id) {
        this.id = id;
    }

    public MockUser() {
        this.id = 0;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public int getId() {
        return this.id;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public boolean isMailEnabled() {
        return this.mailEnabled;
    }

    public void setMailEnabled(boolean mailEnabled) {
        this.mailEnabled = mailEnabled;
    }

    public int getShadowLastChange() {
        return this.shadowLastChange;
    }

    public void setShadowLastChange(int shadowLastChange) {
        this.shadowLastChange = shadowLastChange;
    }

    public void setImapServer(String imapServer) {
        this.imapServer = imapServer;
    }

    public String getImapServer() {
        return this.imapServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public void setMailDomain(String mailDomain) {
        this.mailDomain = mailDomain;
    }

    public String getMailDomain() {
        return this.mailDomain;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setSurname(String sureName) {
        this.surname = sureName;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getMail() {
        return this.mail;
    }

    public String[] getAliases() {
        return new String[]{this.getMail()};
    }

    public Map<String, Set<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttribute(String key, String ... values) {
        this.attributes.put(key, new HashSet<String>(Arrays.asList(values)));
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setAppointmentDays(int appointmentDays) {
        this.appointmentDays = appointmentDays;
    }

    public int getAppointmentDays() {
        return this.appointmentDays;
    }

    public void setTaskDays(int taskDays) {
        this.taskDays = taskDays;
    }

    public int getTaskDays() {
        return this.taskDays;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public int[] getGroups() {
        return (int[])this.groups.clone();
    }

    public void setGroups(int[] groups) {
        this.groups = MockUser.addAllGroupsAndUsersGroup(groups);
    }

    private static int[] addAllGroupsAndUsersGroup(int[] groups) {
        boolean contained = false;
        for (int group : groups) {
            contained = group == 0;
        }
        if (contained) {
            return groups;
        }
        int[] newgroups = new int[groups.length + 1];
        newgroups[0] = 0;
        System.arraycopy(groups, 0, newgroups, 1, groups.length);
        return newgroups;
    }

    public int getContactId() {
        return this.contactId;
    }

    public void setContactId(int contactId) {
        this.contactId = contactId;
    }

    public String getImapLogin() {
        return this.imapLogin;
    }

    public void setImapLogin(String imapLogin) {
        this.imapLogin = imapLogin;
    }

    public String getPasswordMech() {
        return this.passwordMech;
    }

    public void setPasswordMech(String passwordMech) {
        this.passwordMech = passwordMech;
    }

    public void setLoginInfo(String loginInfo) {
        this.loginInfo = loginInfo;
    }

    public String getLoginInfo() {
        return this.loginInfo;
    }

    public Locale getLocale() {
        if (this.locale == null && this.preferredLanguage != null) {
            String[] lang = this.preferredLanguage.split("_");
            this.locale = lang.length == 2 ? new Locale(lang[0], lang[1]) : new Locale(lang[0]);
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getCreatedBy() {
        return 0;
    }

    public boolean isGuest() {
        return false;
    }

    public int getFilestoreId() {
        return this.filestoreId;
    }

    public void setFilestoreId(int filestoreId) {
        this.filestoreId = filestoreId;
    }

    public String getFilestoreName() {
        return this.filestoreName;
    }

    public void setFilestoreName(String filestoreName) {
        this.filestoreName = filestoreName;
    }

    public void setFilestoreAuth(String[] filestoreAuth) {
        this.filestorageAuth = filestoreAuth;
    }

    public String[] getFileStorageAuth() {
        return (String[])this.filestorageAuth.clone();
    }

    public long getFileStorageQuota() {
        return this.fileStorageQuota;
    }

    public void setFileStorageQuota(long fileStorageQuota) {
        this.fileStorageQuota = fileStorageQuota;
    }

    public int getFileStorageOwner() {
        return this.fileStorageOwner;
    }

    public void setFileStorageOwner(int fileStorageOwner) {
        this.fileStorageOwner = fileStorageOwner;
    }
}

