/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish.json;

import com.openexchange.ajax.PermissionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.osgi.ExceptionUtils;
import com.openexchange.publish.json.PublicationJSONErrorMessage;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public abstract class AbstractPublicationServlet
extends PermissionServlet {
    private static final long serialVersionUID = 5880236559668102629L;

    protected AbstractPublicationServlet() {
    }

    protected boolean hasModulePermission(ServerSession session) {
        return session.getUserPermissionBits().isPublication();
    }

    protected void writeOXException(OXException e, HttpServletRequest req, HttpServletResponse resp) {
        switch (((Category)e.getCategories().get(0)).getLogLevel()) {
            case TRACE: {
                this.getLog().trace("", (Throwable)e);
                break;
            }
            case DEBUG: {
                this.getLog().debug("", (Throwable)e);
                break;
            }
            case INFO: {
                this.getLog().info("", (Throwable)e);
                break;
            }
            case WARNING: {
                this.getLog().warn("", (Throwable)e);
                break;
            }
            case ERROR: {
                this.getLog().error("", (Throwable)e);
                break;
            }
        }
        Response response = new Response(this.getSessionObject((ServletRequest)req));
        response.setException(e);
        this.writeResponseSafely(response, resp, (Session)this.getSessionObject((ServletRequest)req));
    }

    protected void writeData(Object data, HttpServletResponse resp, Session session) {
        Response response = new Response();
        response.setData(data);
        this.writeResponseSafely(response, resp, session);
    }

    protected OXException wrapThrowable(Throwable t) {
        ExceptionUtils.handleThrowable((Throwable)t);
        return t instanceof OXException ? (OXException)t : PublicationJSONErrorMessage.THROWABLE.create(t, t.getMessage());
    }

    protected void writeResponseSafely(Response response, HttpServletResponse resp, Session session) {
        try {
            this.writeResponse(response, resp, session);
        }
        catch (IOException e) {
            this.getLog().error("", (Throwable)e);
        }
    }

    protected abstract Logger getLog();
}

