/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.osgi.AbstractServiceRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class RegistryServiceTrackerCustomizer<T>
implements ServiceTrackerCustomizer<T, T> {
    protected final BundleContext context;
    protected final AbstractServiceRegistry registry;
    protected final Class<T> serviceClass;

    public RegistryServiceTrackerCustomizer(BundleContext context, AbstractServiceRegistry registry, Class<T> clazz) {
        this.context = context;
        this.registry = registry;
        this.serviceClass = clazz;
    }

    public T addingService(ServiceReference<T> reference) {
        Object tmp = this.context.getService(reference);
        if (this.serviceClass.isInstance(tmp)) {
            this.registry.addService(this.serviceClass, tmp);
            this.serviceAcquired(tmp);
            return (T)tmp;
        }
        this.context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference<T> reference, T service) {
    }

    public void removedService(ServiceReference<T> reference, T service) {
        T removedService;
        if (null != service && null != (removedService = this.registry.removeService(this.serviceClass))) {
            this.context.ungetService(reference);
            this.serviceReleased(removedService);
        }
    }

    protected void serviceAcquired(T service) {
    }

    protected void serviceReleased(T service) {
    }
}

