/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.osgi.DefaultServiceProvider;
import com.openexchange.osgi.ServiceProvider;
import com.openexchange.osgi.ShutDownRuntimeException;
import com.openexchange.osgi.SimpleServiceProvider;
import com.openexchange.osgi.annotation.SingletonService;
import com.openexchange.osgi.console.DeferredActivatorServiceStateLookup;
import com.openexchange.osgi.console.ServiceStateLookup;
import com.openexchange.server.ServiceLookup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeferredActivator
implements BundleActivator,
ServiceLookup {
    static final Logger LOG = LoggerFactory.getLogger(DeferredActivator.class);
    private static final DeferredActivatorServiceStateLookup STATE_LOOKUP = new DeferredActivatorServiceStateLookup();
    protected static final Class<?>[] EMPTY_CLASSES = new Class[0];
    protected final AtomicBoolean started = new AtomicBoolean();
    protected volatile boolean stopPerformed;
    private long availability;
    private long allAvailable;
    protected volatile BundleContext context;
    private ServiceTracker<?, ?>[] neededServiceTrackers;
    protected ConcurrentMap<Class<?>, ServiceProvider<?>> services;
    protected final ConcurrentMap<Class<?>, ReferencedService<?>> additionalServices = new ConcurrentHashMap(6, 0.9f, 1);

    public static ServiceStateLookup getLookup() {
        return STATE_LOOKUP;
    }

    private <S> DeferredServiceTracker<S> newDeferredTracker(BundleContext context, Class<S> clazz, int index, boolean stopOnUnavailability) {
        return new DeferredServiceTracker<S>(context, clazz, index, stopOnUnavailability);
    }

    protected DeferredActivator() {
    }

    protected boolean stopOnServiceUnavailability() {
        return false;
    }

    protected abstract Class<?>[] getNeededServices();

    protected abstract void handleUnavailability(Class<?> var1);

    protected abstract void handleAvailability(Class<?> var1);

    private final void init(BundleContext context) throws Exception {
        this.updateServiceState();
        Class<?>[] classes = this.getNeededServices();
        if (null == classes || 0 == classes.length) {
            this.services = new ConcurrentHashMap(1, 0.9f, 1);
            this.neededServiceTrackers = new ServiceTracker[0];
            this.allAvailable = 0L;
            this.availability = 0L;
            this.startUp();
        } else {
            int len = classes.length;
            if (len > 0 && new HashSet(Arrays.asList(classes)).size() != len) {
                throw new IllegalArgumentException("Duplicate class/interface provided through getNeededServices()");
            }
            if (LOG.isDebugEnabled()) {
                for (Class<?> trackedService : classes) {
                    if (null != trackedService.getAnnotation(SingletonService.class) || !trackedService.getName().startsWith("com.openexchange.")) continue;
                    LOG.debug("{} tracks needed service {} that is not annotated as a {}", new Object[]{this.getClass().getName(), trackedService.getName(), SingletonService.class.getSimpleName()});
                }
            }
            this.services = new ConcurrentHashMap(len, 0.9f, 1);
            this.neededServiceTrackers = new ServiceTracker[len];
            this.availability = 0L;
            this.allAvailable = (1L << len) - 1L;
            boolean stopOnUnavailability = this.stopOnServiceUnavailability();
            for (int i = 0; i < len; ++i) {
                Class<?> clazz = classes[i];
                DeferredServiceTracker<?> tracker = this.newDeferredTracker(context, clazz, i, stopOnUnavailability);
                tracker.open();
                ServiceTracker<?, ?>[] neededServiceTrackers = this.neededServiceTrackers;
                if (null == neededServiceTrackers) continue;
                neededServiceTrackers[i] = tracker;
            }
            if (len == 0) {
                this.startUp();
            }
        }
    }

    private final void reset() {
        ServiceTracker<?, ?>[] neededServiceTrackers = this.neededServiceTrackers;
        if (null != neededServiceTrackers) {
            for (int i = 0; i < neededServiceTrackers.length; ++i) {
                ServiceTracker<?, ?> tracker = neededServiceTrackers[i];
                if (tracker == null) continue;
                tracker.close();
                neededServiceTrackers[i] = null;
            }
            this.neededServiceTrackers = null;
        }
        this.availability = 0L;
        this.allAvailable = -1L;
        for (ReferencedService referencedService : this.additionalServices.values()) {
            this.context.ungetService(referencedService.reference);
        }
        this.additionalServices.clear();
        ConcurrentMap<Class<?>, ServiceProvider<?>> services = this.services;
        if (null != services) {
            services.clear();
            this.services = null;
        }
        this.context = null;
    }

    protected final void updateServiceState() {
        if (null == this.context) {
            return;
        }
        Class<?>[] classes = this.getNeededServices();
        if (null == classes) {
            STATE_LOOKUP.setState(this.context.getBundle().getSymbolicName(), new ArrayList<String>(0), new ArrayList<String>());
            return;
        }
        ArrayList<String> missing = new ArrayList<String>(classes.length);
        ArrayList<String> present = new ArrayList<String>(classes.length);
        ConcurrentMap<Class<?>, ServiceProvider<?>> services = this.services;
        for (Class<?> clazz : classes) {
            if (services != null && services.containsKey(clazz)) {
                present.add(clazz.getName());
                continue;
            }
            missing.add(clazz.getName());
        }
        STATE_LOOKUP.setState(this.context.getBundle().getSymbolicName(), missing, present);
    }

    protected final void signalAvailability(int index, Class<?> clazz) {
        this.availability |= 1L << index;
        if (this.started.get()) {
            this.handleAvailability(clazz);
        } else if (this.availability == this.allAvailable) {
            try {
                this.startUp();
            }
            catch (Exception e) {
                String errorMsg;
                Throwable t = e;
                if (t.getCause() instanceof BundleException) {
                    t = t.getCause();
                }
                final Bundle bundle = this.context.getBundle();
                final StringBuilder errorBuilder = new StringBuilder(64);
                errorBuilder.append("\nStart-up of bundle \"").append(bundle.getSymbolicName()).append("\" failed: ");
                String string = errorMsg = t instanceof OXException ? ((OXException)t).getLogMessage() : t.getMessage();
                if (null == errorMsg || "null".equals(errorMsg)) {
                    errorBuilder.append(t.getClass().getName());
                } else {
                    errorBuilder.append(errorMsg);
                }
                LOG.error(errorBuilder.toString(), t);
                this.reset();
                if (8 == bundle.getState()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DeferredActivator.shutDownBundle(bundle, errorBuilder);
                        }
                    }).start();
                }
                DeferredActivator.shutDownBundle(bundle, errorBuilder);
            }
        }
    }

    protected static void shutDownBundle(Bundle bundle, StringBuilder errorBuilder) {
        try {
            bundle.stop();
            errorBuilder.setLength(0);
            LOG.error(errorBuilder.append("\n\nBundle \"").append(bundle.getSymbolicName()).append("\" stopped.\n").toString());
        }
        catch (BundleException e) {
            errorBuilder.setLength(0);
            LOG.error(errorBuilder.append("\n\nBundle \"").append(bundle.getSymbolicName()).append("\" could not be stopped.\n").toString());
        }
    }

    final void signalUnavailability(int index, Class<?> clazz, boolean stop) {
        this.availability &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.started.get()) {
            if (stop) {
                try {
                    this.doStop();
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
            } else {
                this.handleUnavailability(clazz);
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        try {
            this.context = context;
            this.init(context);
        }
        catch (ServiceException e) {
            LOG.error("", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    private void startUp() throws Exception {
        this.stopPerformed = false;
        this.startBundle();
        this.started.set(true);
    }

    protected abstract void startBundle() throws Exception;

    public void stop(BundleContext context) throws Exception {
        try {
            this.context = context;
            this.doStop();
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        finally {
            this.stopPerformed = true;
            this.reset();
        }
    }

    private void doStop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            this.stopBundle();
        }
    }

    protected abstract void stopBundle() throws Exception;

    public <S> S getService(Class<? extends S> clazz) {
        if (this.stopPerformed) {
            throw new ShutDownRuntimeException();
        }
        ConcurrentMap<Class<?>, ServiceProvider<?>> services = this.services;
        if (null == services) {
            return null;
        }
        ServiceProvider serviceProvider = (ServiceProvider)services.get(clazz);
        if (null == serviceProvider) {
            return null;
        }
        Object service = serviceProvider.getService();
        if (null == service) {
            return null;
        }
        return clazz.cast(service);
    }

    public <S> S getOptionalService(Class<? extends S> clazz) {
        Object service;
        if (this.stopPerformed) {
            throw new ShutDownRuntimeException();
        }
        ServiceProvider serviceProvider = (ServiceProvider)this.services.get(clazz);
        if (null != serviceProvider && null != (service = serviceProvider.getService())) {
            return clazz.cast(service);
        }
        ConcurrentMap<Class<?>, ReferencedService<?>> additionalServices = this.additionalServices;
        ReferencedService<Object> referencedService = (ReferencedService<Object>)additionalServices.get(clazz);
        if (null == referencedService) {
            ServiceReference serviceReference = this.context.getServiceReference(clazz);
            if (serviceReference == null) {
                return null;
            }
            Object service2 = this.context.getService(serviceReference);
            ReferencedService<Object> newReferencedService = new ReferencedService<Object>(service2, serviceReference);
            referencedService = additionalServices.putIfAbsent(clazz, newReferencedService);
            if (null == referencedService) {
                referencedService = newReferencedService;
            } else {
                this.context.ungetService(serviceReference);
            }
        }
        return referencedService.service;
    }

    protected <S> boolean addService(Class<S> clazz, S service) {
        ConcurrentMap<Class<?>, ServiceProvider<?>> services = this.services;
        if (null == services || !clazz.isInstance(service)) {
            return false;
        }
        return null == services.putIfAbsent(clazz, new SimpleServiceProvider<S>(service));
    }

    protected <S> boolean addServiceAlt(Class<? extends S> clazz, S service) {
        ConcurrentMap<Class<?>, ServiceProvider<?>> services = this.services;
        if (null == services || !clazz.isInstance(service)) {
            return false;
        }
        return null == services.putIfAbsent(clazz, new SimpleServiceProvider<S>(service));
    }

    protected <S> boolean removeService(Class<? extends S> clazz) {
        ConcurrentMap<Class<?>, ServiceProvider<?>> services = this.services;
        if (null == services) {
            return false;
        }
        return null != services.remove(clazz);
    }

    protected final boolean allAvailable() {
        Class<?>[] classes = this.getNeededServices();
        if (null == classes) {
            return true;
        }
        int len = classes.length;
        if (len == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (this.services.containsKey(classes[i])) continue;
            return false;
        }
        return true;
    }

    private final class DeferredServiceTracker<S>
    extends ServiceTracker<S, S> {
        private static final String SERVICE_RANKING = "service.ranking";
        private final Class<? extends S> clazz;
        private final int index;
        private final boolean stopOnUnavailability;

        protected DeferredServiceTracker(BundleContext context, Class<S> clazz, int index, boolean stopOnUnavailability) {
            super(context, clazz, null);
            this.clazz = clazz;
            this.index = index;
            this.stopOnUnavailability = stopOnUnavailability;
        }

        public S addingService(ServiceReference<S> reference) {
            Object service = super.addingService(reference);
            try {
                DefaultServiceProvider<Object> newProvider;
                DefaultServiceProvider<Object> serviceProvider = (DefaultServiceProvider<Object>)DeferredActivator.this.services.get(this.clazz);
                if (null == serviceProvider && null == (serviceProvider = (ServiceProvider)DeferredActivator.this.services.putIfAbsent(this.clazz, newProvider = new DefaultServiceProvider<Object>()))) {
                    serviceProvider = newProvider;
                }
                int ranking = 0;
                Object oRanking = reference.getProperty(SERVICE_RANKING);
                if (null != oRanking) {
                    if (oRanking instanceof Integer) {
                        ranking = (Integer)oRanking;
                    } else {
                        try {
                            ranking = Integer.parseInt(oRanking.toString().trim());
                        }
                        catch (NumberFormatException e) {
                            ranking = 0;
                        }
                    }
                }
                serviceProvider.addService(service, ranking);
                DeferredActivator.this.signalAvailability(this.index, this.clazz);
                DeferredActivator.this.updateServiceState();
                return (S)service;
            }
            catch (Exception e) {
                LOG.error("Failed to add service {}", (Object)service.getClass().getName(), (Object)e);
                this.context.ungetService(reference);
                return null;
            }
        }

        public void removedService(ServiceReference<S> reference, S service) {
            DeferredActivator.this.signalUnavailability(this.index, this.clazz, this.stopOnUnavailability);
            ConcurrentMap<Class<?>, ServiceProvider<?>> services = DeferredActivator.this.services;
            if (services != null) {
                services.remove(this.clazz);
            }
            DeferredActivator.this.updateServiceState();
            super.removedService(reference, service);
        }
    }

    private static final class ReferencedService<S> {
        final ServiceReference<S> reference;
        final S service;

        ReferencedService(S service, ServiceReference<S> reference) {
            this.service = service;
            this.reference = reference;
        }
    }
}

