/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.internet;

import com.openexchange.exception.OXException;
import com.openexchange.messaging.MessagingBodyPart;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.messaging.MultipartContent;
import com.openexchange.messaging.generic.internet.MimeMessagingBodyPart;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;

public class MimeMultipartContent
implements MultipartContent {
    final MimeMultipart mimeMultipart;
    private String sectionId;
    private final String subtype;

    public MimeMultipartContent() {
        this("mixed");
    }

    public MimeMultipartContent(String subtype) {
        this.subtype = subtype;
        this.mimeMultipart = new MimeMultipart(subtype);
    }

    public String getSubType() {
        return this.subtype;
    }

    public String getContentType() {
        return this.mimeMultipart.getContentType();
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    protected MimeMultipartContent(MimeMultipart mimeMultipart) {
        String contentType = mimeMultipart.getContentType();
        if (contentType.startsWith("multipart/mixed", 0)) {
            this.subtype = "mixed";
        } else if (contentType.startsWith("multipart/alternative", 0)) {
            this.subtype = "alternative";
        } else if (contentType.startsWith("multipart/related", 0)) {
            this.subtype = "related";
        } else {
            int spos = contentType.indexOf(47);
            int epos = contentType.indexOf(59);
            this.subtype = (epos < 0 ? contentType.substring(spos + 1) : contentType.substring(spos + 1, epos)).trim();
        }
        this.mimeMultipart = mimeMultipart;
    }

    public MessagingBodyPart get(int index) throws OXException {
        try {
            MimeMessagingBodyPart bodyPart = new MimeMessagingBodyPart((MimePart)this.mimeMultipart.getBodyPart(index), this);
            bodyPart.setSectionId(this.sectionId == null ? Integer.toString(index + 1) : new StringBuilder(8).append(this.sectionId).append('.').append(Integer.toString(index + 1)).toString());
            return bodyPart;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public int getCount() throws OXException {
        try {
            return this.mimeMultipart.getCount();
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void addBodyPart(MimeMessagingBodyPart part) throws OXException {
        try {
            this.mimeMultipart.addBodyPart((BodyPart)part.part);
            part.setParent(this);
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void addBodyPart(MimeMessagingBodyPart part, int index) throws OXException {
        try {
            this.mimeMultipart.addBodyPart((BodyPart)part.part, index);
            part.setParent(this);
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public boolean removeBodyPart(MimeMessagingBodyPart part) throws OXException {
        try {
            return this.mimeMultipart.removeBodyPart((BodyPart)part.part);
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void removeBodyPart(int index) throws OXException {
        try {
            this.mimeMultipart.removeBodyPart(index);
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IndexOutOfBoundsException e) {
            throw MessagingExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

