/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.internet;

import com.openexchange.exception.OXException;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.messaging.ParameterizedMessagingMessage;
import com.openexchange.messaging.generic.internal.InternalUtility;
import com.openexchange.messaging.generic.internet.MimeMessagingBodyPart;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;

public class MimeMessagingMessage
extends MimeMessagingBodyPart
implements ParameterizedMessagingMessage {
    private static final Flags ALL_COLOR_LABELS;
    private static final Flags ALL_SYSTEM_FLAGS;
    final MimeMessage mimeMessage;
    private String folder;
    private InternalUtility.ParsedFlags cachedParsedFlags;
    private long receivedDate;
    private int threadLevel;
    private String id;
    private String picture;
    private final Map<String, Object> parameters;

    public MimeMessagingMessage() {
        super((MimePart)new MimeMessage(MimeDefaultSession.getDefaultSession()), null);
        this.mimeMessage = (MimeMessage)this.part;
        this.parameters = new HashMap<String, Object>(4);
    }

    protected MimeMessagingMessage(MimeMessage mimeMessage) {
        super((MimePart)mimeMessage, null);
        this.mimeMessage = mimeMessage;
        this.parameters = new HashMap<String, Object>(4);
    }

    public int getColorLabel() throws OXException {
        if (null == this.cachedParsedFlags) {
            try {
                this.cachedParsedFlags = InternalUtility.parseFlags(this.mimeMessage.getFlags());
            }
            catch (MessagingException e) {
                throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return this.cachedParsedFlags.getColorLabel();
    }

    public void setColorLabel(int colorLabel) throws OXException {
        try {
            this.mimeMessage.setFlags(ALL_COLOR_LABELS, false);
            Flags newFlags = new Flags();
            newFlags.add(InternalUtility.getColorLabelStringValue(colorLabel));
            this.mimeMessage.setFlags(newFlags, true);
            this.cachedParsedFlags = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public int getFlags() throws OXException {
        if (null == this.cachedParsedFlags) {
            try {
                this.cachedParsedFlags = InternalUtility.parseFlags(this.mimeMessage.getFlags());
            }
            catch (MessagingException e) {
                throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return this.cachedParsedFlags.getFlags();
    }

    public void setFlags(int flags) throws OXException {
        try {
            this.mimeMessage.setFlags(ALL_SYSTEM_FLAGS, false);
            Flags newFlags = InternalUtility.convertMessagingFlags(flags);
            this.mimeMessage.setFlags(newFlags, true);
            this.cachedParsedFlags = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public Collection<String> getUserFlags() throws OXException {
        if (null == this.cachedParsedFlags) {
            try {
                this.cachedParsedFlags = InternalUtility.parseFlags(this.mimeMessage.getFlags());
            }
            catch (MessagingException e) {
                throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return this.cachedParsedFlags.getUserFlags();
    }

    public void setUserFlags(Collection<String> userFlags) throws OXException {
        try {
            String[] strings = this.mimeMessage.getFlags().getUserFlags();
            Flags newFlags = new Flags();
            for (String string : strings) {
                String uf = string;
                if (InternalUtility.isColorLabel(uf) || "$Forwarded".equalsIgnoreCase(uf) || "$MDNSent".equalsIgnoreCase(uf)) continue;
                newFlags.add(uf);
            }
            this.mimeMessage.setFlags(newFlags, false);
            newFlags = new Flags();
            for (String userFlag : userFlags) {
                newFlags.add(userFlag);
            }
            this.mimeMessage.setFlags(newFlags, true);
            this.cachedParsedFlags = null;
        }
        catch (MessagingException e) {
            throw MessagingExceptionCodes.MESSAGING_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalStateException e) {
            throw MessagingExceptionCodes.READ_ONLY.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public String getFolder() {
        if (null == this.folder) {
            Folder folder = this.mimeMessage.getFolder();
            return null == folder ? null : folder.getFullName();
        }
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public long getReceivedDate() {
        return this.receivedDate;
    }

    public void setReceivedDate(long receivedDate) {
        this.receivedDate = receivedDate;
    }

    public int getThreadLevel() {
        return this.threadLevel;
    }

    public void setThreadLevel(int threadLevel) {
        this.threadLevel = threadLevel;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getUrl() throws OXException {
        return null;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public void putParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public boolean putParameterIfAbsent(String name, Object value) {
        if (this.parameters.containsKey(name)) {
            return false;
        }
        this.parameters.put(name, value);
        return true;
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public boolean containsParameter(String name) {
        return this.parameters.containsKey(name);
    }

    static {
        StringBuilder sb = new StringBuilder(6);
        Flags flags = new Flags();
        for (int i = 0; i <= 10; ++i) {
            sb.setLength(0);
            flags.add(sb.append("$cl_").append(i).toString());
            sb.setLength(0);
            flags.add(sb.append("cl_").append(i).toString());
        }
        ALL_COLOR_LABELS = flags;
        flags = new Flags();
        flags.add(Flags.Flag.ANSWERED);
        flags.add(Flags.Flag.DELETED);
        flags.add(Flags.Flag.DRAFT);
        flags.add(Flags.Flag.FLAGGED);
        flags.add(Flags.Flag.SEEN);
        flags.add(Flags.Flag.USER);
        flags.add("$Forwarded");
        flags.add("$MDNSent");
        ALL_SYSTEM_FLAGS = flags;
    }
}

