/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java.util;

import java.util.UUID;

public final class UUIDs {
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final int UUID_BYTE_LENGTH = 16;

    private UUIDs() {
    }

    public static String getUnformattedStringFromRandom() {
        return UUIDs.getUnformattedString(UUID.randomUUID());
    }

    public static String getUnformattedString(UUID uuid) {
        return new String(UUIDs.encodeHex(UUIDs.toByteArray(uuid)));
    }

    private static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = digits[(0xF0 & data[i]) >>> 4];
            out[j++] = digits[0xF & data[i]];
        }
        return out;
    }

    public static UUID fromUnformattedString(String unformattedString) {
        return UUIDs.toUUID(UUIDs.decodeHex(unformattedString));
    }

    private static byte[] decodeHex(String data) throws IllegalArgumentException {
        int len = data.length();
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = UUIDs.toDigit(data.charAt(j), j) << 4;
            f |= UUIDs.toDigit(data.charAt(++j), j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static int toDigit(char ch, int index) throws IllegalArgumentException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal charcter " + ch + " at index " + index);
        }
        return digit;
    }

    public static byte[] toByteArray(UUID uuid) {
        return UUIDs.append(UUIDs.toBytes(uuid.getMostSignificantBits()), UUIDs.toBytes(uuid.getLeastSignificantBits()));
    }

    public static UUID toUUID(byte[] bytes) {
        int i;
        if (null == bytes) {
            throw new IllegalArgumentException("Byte array is null.");
        }
        if (bytes.length != 16) {
            throw new IllegalArgumentException("UUID must be contructed using a 16 byte array.");
        }
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(bytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(bytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    private static byte[] append(byte[] first, byte[] second) {
        byte[] bytes = new byte[first.length + second.length];
        System.arraycopy(first, 0, bytes, 0, first.length);
        System.arraycopy(second, 0, bytes, first.length, second.length);
        return bytes;
    }

    private static byte[] toBytes(long n) {
        byte[] b = new byte[8];
        long byteVal = n;
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)byteVal;
            byteVal >>>= 8;
        }
        b[0] = (byte)byteVal;
        return b;
    }
}

