/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

public final class ImageTypeDetector {
    private static final byte[] PREFIX_BITMAP = new byte[]{66, 77};
    private static final byte[] PREFIX_FITS = new byte[]{83, 73, 77, 80, 76, 69};
    private static final byte[] PREFIX_GIF = new byte[]{71, 73, 70, 56};
    private static final byte[] PREFIX_GKSM = new byte[]{71, 75, 83, 77};
    private static final byte[] PREFIX_IRIS = new byte[]{1, -38};
    private static final byte[] PREFIX_ITC = new byte[]{-15, 0, 64, -69};
    private static final byte[] PREFIX_JPEG = new byte[]{-1, -40, -1, -32};
    private static final byte[] PREFIX_JPEG2 = new byte[]{-1, -40, -1, -31};
    private static final byte[] PREFIX_JPEG3 = new byte[]{-1, -40, -1, -30};
    private static final byte[] PREFIX_NIFF = new byte[]{73, 73, 78, 49};
    private static final byte[] PREFIX_PM = new byte[]{86, 73, 69, 87};
    private static final byte[] PREFIX_PNG = new byte[]{-119, 80, 78, 71};
    private static final byte[] PREFIX_POSTSCRIPT = new byte[]{37, 33};
    private static final byte[] PREFIX_SUN_RASTERFILE = new byte[]{89, -90, 106, -107};
    private static final byte[] PREFIX_TIFF_BIGENDIAN = new byte[]{77, 77, 0, 42};
    private static final byte[] PREFIX_TIFF_LITTLEENDIAN = new byte[]{73, 73, 42, 0};
    private static final byte[] PREFIX_XCF_GIMP = new byte[]{103, 105, 109, 112, 32, 120, 99, 102, 32, 118};
    private static final byte[] PREFIX_XFIG = new byte[]{35, 70, 73, 71};
    private static final byte[] PREFIX_XPM = new byte[]{47, 42, 32, 88, 80, 77, 32, 42, 47};

    private ImageTypeDetector() {
    }

    public static String getMimeType(byte[] bytes) {
        return ImageTypeDetector.getMimeType(bytes, 0, bytes.length);
    }

    public static String getMimeType(byte[] bytes, String defaultMimeType) {
        return ImageTypeDetector.getMimeType(bytes, 0, bytes.length, defaultMimeType);
    }

    public static String getMimeType(byte[] bytes, int off, int len) {
        return ImageTypeDetector.getMimeType(bytes, off, len, "application/octet-stream");
    }

    public static String getMimeType(byte[] bytes, int off, int len, String defaultMimeType) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > bytes.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (ImageTypeDetector.startsWith(PREFIX_JPEG, bytes, off, len) || ImageTypeDetector.startsWith(PREFIX_JPEG2, bytes, off, len) || ImageTypeDetector.startsWith(PREFIX_JPEG3, bytes, off, len)) {
            return "image/jpeg";
        }
        if (ImageTypeDetector.startsWith(PREFIX_BITMAP, bytes, off, len)) {
            return "image/x-ms-bmp";
        }
        if (ImageTypeDetector.startsWith(PREFIX_PNG, bytes, off, len)) {
            return "image/png";
        }
        if (ImageTypeDetector.startsWith(PREFIX_GIF, bytes, off, len)) {
            return "image/gif";
        }
        if (ImageTypeDetector.startsWith(PREFIX_XPM, bytes, off, len)) {
            return "image/x-xpixmap";
        }
        if (ImageTypeDetector.startsWith(PREFIX_TIFF_BIGENDIAN, bytes, off, len)) {
            return "image/tiff";
        }
        if (ImageTypeDetector.startsWith(PREFIX_TIFF_LITTLEENDIAN, bytes, off, len)) {
            return "image/tiff";
        }
        if (ImageTypeDetector.startsWith(PREFIX_POSTSCRIPT, bytes, off, len)) {
            return "application/postscript";
        }
        if (ImageTypeDetector.startsWith(PREFIX_FITS, bytes, off, len)) {
            return "image/fits";
        }
        if (ImageTypeDetector.startsWith(PREFIX_GKSM, bytes, off, len)) {
            return "image/gks";
        }
        if (ImageTypeDetector.startsWith(PREFIX_IRIS, bytes, off, len)) {
            return "image/x-rgb";
        }
        if (ImageTypeDetector.startsWith(PREFIX_ITC, bytes, off, len)) {
            return "image/itc";
        }
        if (ImageTypeDetector.startsWith(PREFIX_NIFF, bytes, off, len)) {
            return "image/niff";
        }
        if (ImageTypeDetector.startsWith(PREFIX_PM, bytes, off, len)) {
            return "image/x-portable-anymap";
        }
        if (ImageTypeDetector.startsWith(PREFIX_SUN_RASTERFILE, bytes, off, len)) {
            return "image/x-cmu-raste";
        }
        if (ImageTypeDetector.startsWith(PREFIX_XCF_GIMP, bytes, off, len)) {
            return "image/xcf";
        }
        if (ImageTypeDetector.startsWith(PREFIX_XFIG, bytes, off, len)) {
            return "image/fig";
        }
        return defaultMimeType;
    }

    private static boolean startsWith(byte[] prefix, byte[] bytes, int off, int len) {
        int pc = prefix.length;
        if (len < pc) {
            return false;
        }
        if (off > 0) {
            while (--pc >= 0) {
                if (bytes[off + pc] == prefix[pc]) continue;
                return false;
            }
        } else {
            while (--pc >= 0) {
                if (bytes[pc] == prefix[pc]) continue;
                return false;
            }
        }
        return true;
    }
}

