/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentList<E>
implements List<E> {
    protected final AtomicReference<List<E>> ref;

    public ConcurrentList() {
        this.ref = new AtomicReference(Collections.emptyList());
    }

    public ConcurrentList(Collection<? extends E> c) {
        this.ref = new AtomicReference<ArrayList<E>>(new ArrayList<E>(c));
    }

    public List<E> getSnapshot() {
        return Collections.unmodifiableList(this.ref.get());
    }

    @Override
    public int size() {
        return this.ref.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.ref.get().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.ref.get().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.ref.get().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.ref.get().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.ref.get().toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean added;
        ArrayList<E> list;
        List<E> expected;
        do {
            expected = this.ref.get();
            list = new ArrayList<E>(expected);
            added = list.add(e);
        } while (!this.ref.compareAndSet(expected, list));
        return added;
    }

    public boolean addIfAbsent(E e) {
        boolean added;
        ArrayList<E> list;
        List<E> expected;
        do {
            if ((list = new ArrayList<E>(expected = this.ref.get())).contains(e)) {
                return false;
            }
            added = list.add(e);
        } while (!this.ref.compareAndSet(expected, list));
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed;
        ArrayList<E> list;
        List<E> expected;
        do {
            expected = this.ref.get();
            list = new ArrayList<E>(expected);
            removed = list.remove(o);
        } while (!this.ref.compareAndSet(expected, list));
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.ref.get().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added;
        ArrayList<? extends E> list;
        List<E> expected;
        do {
            expected = this.ref.get();
            list = new ArrayList<E>(expected);
            added = list.addAll(c);
        } while (!this.ref.compareAndSet(expected, list));
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean added;
        ArrayList<? extends E> list;
        List<E> expected;
        do {
            expected = this.ref.get();
            list = new ArrayList<E>(expected);
            added = list.addAll(index, c);
        } while (!this.ref.compareAndSet(expected, list));
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed;
        ArrayList<E> list;
        List<E> expected;
        do {
            expected = this.ref.get();
            list = new ArrayList<E>(expected);
            removed = list.removeAll(c);
        } while (!this.ref.compareAndSet(expected, list));
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retained;
        ArrayList<E> list;
        List<E> expected;
        do {
            expected = this.ref.get();
            list = new ArrayList<E>(expected);
            retained = list.retainAll(c);
        } while (!this.ref.compareAndSet(expected, list));
        return retained;
    }

    @Override
    public void clear() {
        List list;
        List<E> expected;
        while (!this.ref.compareAndSet(expected = this.ref.get(), list = Collections.emptyList())) {
        }
    }

    @Override
    public E get(int index) {
        return this.ref.get().get(index);
    }

    @Override
    public E set(int index, E element) {
        E ret;
        ArrayList<E> list;
        List<E> expected;
        do {
            expected = this.ref.get();
            list = new ArrayList<E>(expected);
            ret = list.set(index, element);
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public void add(int index, E element) {
        ArrayList<E> list;
        List<E> expected;
        do {
            expected = this.ref.get();
            list = new ArrayList<E>(expected);
            list.add(index, element);
        } while (!this.ref.compareAndSet(expected, list));
    }

    @Override
    public E remove(int index) {
        Object ret;
        ArrayList<E> list;
        List<E> expected;
        do {
            expected = this.ref.get();
            list = new ArrayList<E>(expected);
            ret = list.remove(index);
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public int indexOf(Object o) {
        return this.ref.get().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.ref.get().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.ref.get().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.ref.get().listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.ref.get().subList(fromIndex, toIndex);
    }
}

