/*
 * Decompiled with CFR 0.152.
 */
package com.davekoelle;

import com.openexchange.java.Collators;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlphanumComparator
implements Comparator<String> {
    private static final Logger LOG;
    private static final Map<Locale, Collator> COLLATOR_OVERRIDES;
    private static final Locale DEFAULT_LOCALE;
    private static final Collator DEFAULT_COLLATOR;
    private Collator collator;
    private final Locale locale;

    public AlphanumComparator() {
        this(null);
    }

    public AlphanumComparator(Locale locale) {
        if (null == locale) {
            this.collator = DEFAULT_COLLATOR;
            this.locale = DEFAULT_LOCALE;
        } else if (COLLATOR_OVERRIDES.containsKey(locale)) {
            this.locale = locale;
            this.collator = COLLATOR_OVERRIDES.get(locale);
        } else {
            this.locale = locale;
            this.collator = Collators.getSecondaryInstance(locale);
        }
    }

    private final String getChunk(String s, int length, int start) {
        char c = s.charAt(start);
        boolean digit = Character.isDigit(c);
        StringBuilder chunk = new StringBuilder(length - start);
        chunk.append(c);
        for (int marker = start + 1; marker < length && digit == Character.isDigit(c = s.charAt(marker)); ++marker) {
            chunk.append(c);
        }
        return chunk.toString();
    }

    @Override
    public int compare(String s1, String s2) {
        int thisMarker = 0;
        int thatMarker = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (thisMarker < s1Length && thatMarker < s2Length) {
            int result;
            String thisChunk = this.getChunk(s1, s1Length, thisMarker);
            thisMarker += thisChunk.length();
            String thatChunk = this.getChunk(s2, s2Length, thatMarker);
            thatMarker += thatChunk.length();
            if (Character.isDigit(thisChunk.charAt(0)) && Character.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.length();
                result = thisChunkLength - thatChunk.length();
                if (result == 0) {
                    for (int i = 0; i < thisChunkLength; ++i) {
                        result = thisChunk.charAt(i) - thatChunk.charAt(i);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                result = this.collator.compare(thisChunk.toLowerCase(this.locale), thatChunk.toLowerCase(this.locale));
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }

    private static Map<Locale, Collator> initCollatorOverrides() {
        HashMap<Locale, Collator> overrides = new HashMap<Locale, Collator>();
        Collator defaultJapaneseCollator = Collator.getInstance(Locale.JAPANESE);
        if (null != defaultJapaneseCollator && RuleBasedCollator.class.isInstance(defaultJapaneseCollator)) {
            int c;
            StringBuilder customRules = new StringBuilder(((RuleBasedCollator)defaultJapaneseCollator).getRules());
            customRules.append("& \u0000");
            for (c = 12352; c <= 12543; ++c) {
                customRules.append('<').append((char)c);
            }
            for (c = 19968; c <= 40895; ++c) {
                customRules.append('<').append((char)c);
            }
            RuleBasedCollator customJapaneseCollator = null;
            try {
                customJapaneseCollator = new RuleBasedCollator(customRules.toString());
            }
            catch (ParseException e) {
                LOG.warn("Error initializing custom collator", (Throwable)e);
            }
            if (null != customJapaneseCollator) {
                customJapaneseCollator.setStrength(1);
                overrides.put(Locale.JAPAN, customJapaneseCollator);
                overrides.put(Locale.JAPANESE, customJapaneseCollator);
            }
        }
        return overrides;
    }

    static {
        Collator collator;
        LOG = LoggerFactory.getLogger(AlphanumComparator.class);
        DEFAULT_LOCALE = Locale.US;
        DEFAULT_COLLATOR = collator = Collators.getSecondaryInstance(DEFAULT_LOCALE);
        COLLATOR_OVERRIDES = Collections.unmodifiableMap(AlphanumComparator.initCollatorOverrides());
    }
}

