/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.HTMLDetector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class HTMLDetectorTest {
    @Test
    public final void testDetectJSEventHandler() {
        try {
            byte[] svgImage = "<svg onload=\"alert(document.domain)\" xmlns=\"http://www.w3.org/2000/svg\"\n        xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n        xmlns:ev=\"http://www.w3.org/2001/xml-events\"\n        version=\"1.1\" baseProfile=\"full\"\n        width=\"700px\" height=\"400px\" viewBox=\"0 0 700 400\">\n    <text x=\"20\" y=\"40\">oha!</text>\n</svg>".getBytes();
            boolean containsHTMLTags = HTMLDetector.containsHTMLTags((InputStream)new ByteArrayInputStream(svgImage), (boolean)false);
            Assert.assertTrue((String)"HTMLDetector should have found \"onload\" JavaScript event handler.", (boolean)containsHTMLTags);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public final void testDetectClosingHTMLTags_Bug33577() {
        String htmlContent = "<td>My Name</td></tr></tbody></table></body></html>";
        boolean containsHTMLTags = HTMLDetector.containsHTMLTags((String)"<td>My Name</td></tr></tbody></table></body></html>", (boolean)true);
        Assert.assertTrue((String)"HTMLDetector should have found html.", (boolean)containsHTMLTags);
    }
}

