/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.google.api.client;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.google.api.client.services.Services;
import com.openexchange.java.Strings;
import com.openexchange.oauth.API;
import com.openexchange.oauth.DefaultOAuthToken;
import com.openexchange.oauth.OAuthAccount;
import com.openexchange.oauth.OAuthExceptionCodes;
import com.openexchange.oauth.OAuthService;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.session.Session;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Google2Api;
import org.scribe.exceptions.OAuthException;
import org.scribe.model.Token;

public class GoogleApiClients {
    public static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();

    private GoogleApiClients() {
    }

    public static OAuthAccount getDefaultGoogleAccount(Session session) throws OXException {
        return GoogleApiClients.getDefaultGoogleAccount(session, true);
    }

    public static OAuthAccount getDefaultGoogleAccount(Session session, boolean reacquireIfExpired) throws OXException {
        OAuthService oAuthService = Services.optService(OAuthService.class);
        if (null == oAuthService) {
            throw ServiceExceptionCode.absentService(OAuthService.class);
        }
        OAuthAccount defaultAccount = oAuthService.getDefaultAccount(API.GOOGLE, session);
        if (reacquireIfExpired) {
            try {
                ServiceBuilder serviceBuilder = new ServiceBuilder().provider(Google2Api.class);
                serviceBuilder.apiKey(defaultAccount.getMetaData().getAPIKey(session)).apiSecret(defaultAccount.getMetaData().getAPISecret(session));
                Google2Api.GoogleOAuth2Service scribeOAuthService = (Google2Api.GoogleOAuth2Service)serviceBuilder.build();
                int expiry = scribeOAuthService.getExpiry(defaultAccount.getToken());
                if (expiry < 300) {
                    String refreshToken = defaultAccount.getSecret();
                    Token accessToken = scribeOAuthService.getAccessToken(new Token(defaultAccount.getToken(), defaultAccount.getSecret()), null);
                    if (!Strings.isEmpty((String)accessToken.getSecret())) {
                        refreshToken = accessToken.getSecret();
                    }
                    int accountId = defaultAccount.getId();
                    HashMap<String, Object> arguments = new HashMap<String, Object>(3);
                    arguments.put("requestToken", new DefaultOAuthToken(accessToken.getToken(), refreshToken));
                    arguments.put("session", session);
                    oAuthService.updateAccount(accountId, arguments, session.getUserId(), session.getContextId());
                    defaultAccount = oAuthService.getAccount(accountId, session, session.getUserId(), session.getContextId());
                }
            }
            catch (OAuthException e) {
                if (e.getMessage().indexOf("\"invalid_grant\"") >= 0) {
                    throw OAuthExceptionCodes.INVALID_ACCOUNT_EXTENDED.create((Throwable)e, new Object[]{defaultAccount.getDisplayName(), defaultAccount.getId()});
                }
                throw OAuthExceptionCodes.OAUTH_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return defaultAccount;
    }

    public static OAuthAccount getGoogleAccount(int accountId, Session session) throws OXException {
        return GoogleApiClients.getGoogleAccount(accountId, session, true);
    }

    public static OAuthAccount getGoogleAccount(int accountId, Session session, boolean reacquireIfExpired) throws OXException {
        OAuthService oAuthService = Services.optService(OAuthService.class);
        if (null == oAuthService) {
            throw ServiceExceptionCode.absentService(OAuthService.class);
        }
        OAuthAccount googleAccount = oAuthService.getAccount(accountId, session, session.getUserId(), session.getContextId());
        if (reacquireIfExpired) {
            ServiceBuilder serviceBuilder = new ServiceBuilder().provider(Google2Api.class);
            serviceBuilder.apiKey(googleAccount.getMetaData().getAPIKey(session)).apiSecret(googleAccount.getMetaData().getAPISecret(session));
            Google2Api.GoogleOAuth2Service scribeOAuthService = (Google2Api.GoogleOAuth2Service)serviceBuilder.build();
            int expiry = scribeOAuthService.getExpiry(googleAccount.getToken());
            if (expiry < 300) {
                String refreshToken = googleAccount.getSecret();
                Token accessToken = scribeOAuthService.getAccessToken(new Token(googleAccount.getToken(), googleAccount.getSecret()), null);
                if (!Strings.isEmpty((String)accessToken.getSecret())) {
                    refreshToken = accessToken.getSecret();
                }
                HashMap<String, Object> arguments = new HashMap<String, Object>(3);
                arguments.put("requestToken", new DefaultOAuthToken(accessToken.getToken(), refreshToken));
                arguments.put("session", session);
                oAuthService.updateAccount(accountId, arguments, session.getUserId(), session.getContextId());
                googleAccount = oAuthService.getAccount(accountId, session, session.getUserId(), session.getContextId());
            }
        }
        return googleAccount;
    }

    public static long getGoogleAccountExpiry(OAuthAccount googleAccount, Session session) throws OXException {
        if (null == googleAccount) {
            return -1L;
        }
        ServiceBuilder serviceBuilder = new ServiceBuilder().provider(Google2Api.class);
        serviceBuilder.apiKey(googleAccount.getMetaData().getAPIKey(session)).apiSecret(googleAccount.getMetaData().getAPISecret(session));
        Google2Api.GoogleOAuth2Service scribeOAuthService = (Google2Api.GoogleOAuth2Service)serviceBuilder.build();
        int expiry = scribeOAuthService.getExpiry(googleAccount.getToken());
        return expiry;
    }

    public static OAuthAccount ensureNonExpiredGoogleAccount(OAuthAccount googleAccount, Session session) throws OXException {
        if (null == googleAccount) {
            return googleAccount;
        }
        OAuthService oAuthService = Services.optService(OAuthService.class);
        if (null == oAuthService) {
            throw ServiceExceptionCode.absentService(OAuthService.class);
        }
        ServiceBuilder serviceBuilder = new ServiceBuilder().provider(Google2Api.class);
        serviceBuilder.apiKey(googleAccount.getMetaData().getAPIKey(session)).apiSecret(googleAccount.getMetaData().getAPISecret(session));
        Google2Api.GoogleOAuth2Service scribeOAuthService = (Google2Api.GoogleOAuth2Service)serviceBuilder.build();
        int expiry = scribeOAuthService.getExpiry(googleAccount.getToken());
        if (expiry >= 300) {
            return null;
        }
        String refreshToken = googleAccount.getSecret();
        Token accessToken = scribeOAuthService.getAccessToken(new Token(googleAccount.getToken(), googleAccount.getSecret()), null);
        if (!Strings.isEmpty((String)accessToken.getSecret())) {
            refreshToken = accessToken.getSecret();
        }
        int accountId = googleAccount.getId();
        HashMap<String, Object> arguments = new HashMap<String, Object>(3);
        arguments.put("requestToken", new DefaultOAuthToken(accessToken.getToken(), refreshToken));
        arguments.put("session", session);
        oAuthService.updateAccount(accountId, arguments, session.getUserId(), session.getContextId());
        return oAuthService.getAccount(accountId, session, session.getUserId(), session.getContextId());
    }

    public static GoogleCredential getCredentials(Session session) throws OXException {
        OAuthAccount defaultAccount = GoogleApiClients.getDefaultGoogleAccount(session);
        return GoogleApiClients.getCredentials(defaultAccount, session);
    }

    public static GoogleCredential getCredentials(OAuthAccount googleOAuthAccount, Session session) throws OXException {
        try {
            NetHttpTransport transport = new NetHttpTransport.Builder().doNotValidateCertificate().build();
            return new GoogleCredential.Builder().setClientSecrets(googleOAuthAccount.getMetaData().getAPIKey(session), googleOAuthAccount.getMetaData().getAPISecret(session)).setJsonFactory(JSON_FACTORY).setTransport((HttpTransport)transport).build().setRefreshToken(googleOAuthAccount.getSecret()).setAccessToken(googleOAuthAccount.getToken());
        }
        catch (GeneralSecurityException e) {
            throw OAuthExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static String getGoogleProductName() {
        ConfigurationService configService = Services.getService(ConfigurationService.class);
        return null == configService ? "" : configService.getProperty("com.openexchange.oauth.google.productName", "");
    }
}

