/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond;

import com.openexchange.session.Session;
import java.util.LinkedList;
import java.util.List;

public class SessionFilter {
    public static final String CONTEXT_ID = "contextId";
    public static final String USER_ID = "userId";
    public static final String SESSION_ID = "sessionId";
    public static final String SECRET = "secret";
    public static final String HASH = "hash";
    public static final String AUTH_ID = "authId";
    public static final String CLIENT = "client";
    private final String filterString;
    private final Matcher matcher;

    private SessionFilter(String filterString, Matcher matcher) {
        this.filterString = filterString;
        this.matcher = matcher;
    }

    public static SessionFilter create(String filterString) throws IllegalArgumentException {
        Matcher matcher = new Parser(filterString).parse();
        return new SessionFilter(filterString, matcher);
    }

    public boolean apply(Session session) {
        return this.matcher.matches(new SessionMatchee(session));
    }

    public String toString() {
        return this.filterString;
    }

    static final class Simple
    implements Matcher {
        private final String attr;
        private final String value;
        private final FilterType type;

        private Simple(String attr, String value, FilterType type) {
            this.attr = attr;
            this.value = value;
            this.type = type;
        }

        public String getAttr() {
            return this.attr;
        }

        public String getValue() {
            return this.value;
        }

        public FilterType getType() {
            return this.type;
        }

        @Override
        public boolean matches(Matchee matchee) {
            return matchee.matches(this.attr, this.value, this.type);
        }
    }

    static final class Junction
    implements Matcher {
        private final List<Matcher> matchers;
        private final boolean and;

        private Junction(boolean and, List<Matcher> matchers) {
            this.and = and;
            this.matchers = matchers;
        }

        @Override
        public boolean matches(Matchee matchee) {
            if (this.and) {
                for (Matcher matcher : this.matchers) {
                    if (matcher.matches(matchee)) continue;
                    return false;
                }
                return true;
            }
            for (Matcher matcher : this.matchers) {
                if (!matcher.matches(matchee)) continue;
                return true;
            }
            return false;
        }
    }

    static final class Not
    implements Matcher {
        private final Matcher matcher;

        private Not(Matcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public boolean matches(Matchee matchee) {
            return !this.matcher.matches(matchee);
        }
    }

    static enum FilterType implements Applicator
    {
        EQUAL(new Applicator(){

            @Override
            public boolean isApplicable(String str1, String str2) {
                if (str1 == null) {
                    return str2 == null;
                }
                if (str2 == null) {
                    return false;
                }
                return str1.equals(str2);
            }
        });

        private final Applicator applicator;

        private FilterType(Applicator applicator) {
            this.applicator = applicator;
        }

        @Override
        public boolean isApplicable(String str1, String str2) {
            return this.applicator.isApplicable(str1, str2);
        }
    }

    static interface Applicator {
        public boolean isApplicable(String var1, String var2);
    }

    static interface Matchee {
        public boolean matches(String var1, String var2, FilterType var3);
    }

    static interface Matcher {
        public boolean matches(Matchee var1);
    }

    static final class Parser {
        private final String filterString;
        private final char[] filterChars;
        private int pos;

        Parser(String filterString) {
            this.filterString = filterString;
            this.filterChars = filterString.toCharArray();
            this.pos = 0;
        }

        Matcher parse() throws IllegalArgumentException {
            try {
                Matcher parseFilter = this.parseFilter();
                if (this.pos != this.filterChars.length) {
                    throw new IllegalArgumentException("Unexpected end of filter string '" + this.filterString + "'");
                }
                return parseFilter;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unexpected end of filter string '" + this.filterString + "'");
            }
        }

        private Matcher parseFilter() {
            this.skipWhitespace();
            if ('(' != this.filterChars[this.pos++]) {
                throw new IllegalArgumentException("Missing '(' at position " + this.pos + " of '" + this.filterString + "'");
            }
            Matcher filterComp = this.parseFilterComp();
            this.skipWhitespace();
            if (')' != this.filterChars[this.pos++]) {
                throw new IllegalArgumentException("Missing ')' at position " + this.pos + " of '" + this.filterString + "'");
            }
            this.skipWhitespace();
            return filterComp;
        }

        private Matcher parseFilterComp() {
            this.skipWhitespace();
            switch (this.filterChars[this.pos]) {
                case '&': {
                    ++this.pos;
                    return new Junction(true, this.parseFilterList());
                }
                case '|': {
                    ++this.pos;
                    return new Junction(false, this.parseFilterList());
                }
                case '!': {
                    ++this.pos;
                    return new Not(this.parseFilter());
                }
            }
            return this.parseSimple();
        }

        private List<Matcher> parseFilterList() {
            this.skipWhitespace();
            LinkedList<Matcher> matchers = new LinkedList<Matcher>();
            while (this.pos < this.filterChars.length) {
                matchers.add(this.parseFilter());
                if (this.filterChars[this.pos] != ')') continue;
            }
            if (matchers.size() < 2) {
                throw new IllegalArgumentException("Unexpected filter expression: " + this.filterString + "'");
            }
            return matchers;
        }

        private Simple parseSimple() {
            this.skipWhitespace();
            StringBuilder attr = new StringBuilder();
            StringBuilder value = new StringBuilder();
            FilterType type = null;
            boolean parseValue = false;
            int length = this.filterChars.length;
            while (this.pos < length) {
                char c = this.filterChars[this.pos];
                if (c == '=') {
                    type = FilterType.EQUAL;
                    parseValue = true;
                } else {
                    if (c == ')') break;
                    if (parseValue) {
                        value.append(c);
                    } else {
                        attr.append(c);
                    }
                }
                ++this.pos;
            }
            if (attr.length() == 0) {
                throw new IllegalArgumentException("Missing attribute at position " + this.pos + " of '" + this.filterString + "'");
            }
            if (value.length() == 0) {
                throw new IllegalArgumentException("Missing value at position " + this.pos + " of '" + this.filterString + "'");
            }
            if (type == null) {
                throw new IllegalArgumentException("Missing filter type at position " + this.pos + " of '" + this.filterString + "'");
            }
            return new Simple(attr.toString(), value.toString(), type);
        }

        private void skipWhitespace() {
            while (this.pos < this.filterChars.length && Character.isWhitespace(this.filterChars[this.pos])) {
                ++this.pos;
            }
        }
    }

    static final class SessionMatchee
    implements Matchee {
        private final Session session;

        private SessionMatchee(Session session) {
            this.session = session;
        }

        @Override
        public boolean matches(String attr, String value, FilterType type) {
            if (SessionFilter.CONTEXT_ID.equals(attr)) {
                return type.isApplicable(Integer.toString(this.session.getContextId()), value);
            }
            if (SessionFilter.USER_ID.equals(attr)) {
                return type.isApplicable(Integer.toString(this.session.getUserId()), value);
            }
            if (SessionFilter.SESSION_ID.equals(attr)) {
                String sessionID = this.session.getSessionID();
                if (sessionID == null) {
                    return false;
                }
                return type.isApplicable(sessionID, value);
            }
            if (SessionFilter.SECRET.equals(attr)) {
                String secret = this.session.getSecret();
                if (secret == null) {
                    return false;
                }
                return type.isApplicable(secret, value);
            }
            if (SessionFilter.HASH.equals(attr)) {
                String hash = this.session.getHash();
                if (hash == null) {
                    return false;
                }
                return type.isApplicable(hash, value);
            }
            if (SessionFilter.AUTH_ID.equals(attr)) {
                String authId = this.session.getAuthId();
                if (authId == null) {
                    return false;
                }
                return type.isApplicable(authId, value);
            }
            if (SessionFilter.CLIENT.equals(attr)) {
                String client = this.session.getClient();
                if (client == null) {
                    return false;
                }
                return type.isApplicable(client, value);
            }
            Object parameter = this.session.getParameter(attr);
            if (parameter != null && String.class.isAssignableFrom(parameter.getClass())) {
                return type.isApplicable((String)parameter, value);
            }
            return false;
        }
    }
}

