/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ThreadCountEntry
implements Comparable<ThreadCountEntry> {
    private static final Object PRESENT = new Object();
    private final ReadWriteLock readWriteLock;
    private final String sessionId;
    private int count;
    private final Map<Thread, Object> threads;

    public ThreadCountEntry(String sessionId) {
        this.sessionId = sessionId;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.count = 0;
        this.threads = new HashMap<Thread, Object>(16);
    }

    @Override
    public int compareTo(ThreadCountEntry o) {
        int anotherVal;
        int thisVal = this.get();
        return thisVal < (anotherVal = o.get()) ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get() {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Thread> getThreads() {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            HashSet<Thread> hashSet = new HashSet<Thread>(this.threads.keySet());
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Thread> getThreads(int threshold) {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            if (this.count < threshold) {
                Set<Thread> set = Collections.emptySet();
                return set;
            }
            HashSet<Thread> hashSet = new HashSet<Thread>(this.threads.keySet());
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            this.count = 0;
            this.threads.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementAndGet() {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (null != this.threads.put(Thread.currentThread(), PRESENT)) {
                int n = this.count;
                return n;
            }
            int n = ++this.count;
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrementAndGet() {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            Object removed = this.threads.remove(Thread.currentThread());
            if (null == removed || this.count <= 0) {
                int n = this.count;
                return n;
            }
            int n = --this.count;
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }
}

