/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.passwordmechs;

import com.damienmiller.BCrypt;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.passwordmechs.IPasswordMech;
import com.openexchange.passwordmechs.PasswordMechExceptionCode;
import com.openexchange.passwordmechs.mechs.SHACrypt;
import com.openexchange.passwordmechs.mechs.UnixCrypt;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PasswordMech implements IPasswordMech
{
    CRYPT("{CRYPT}", new Encoder(){

        @Override
        public String encode(String str) throws OXException {
            try {
                return UnixCrypt.crypt(str);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("Error encrypting password according to CRYPT mechanism", (Throwable)e);
                throw PasswordMechExceptionCode.UNSUPPORTED_ENCODING.create(e, e.getMessage());
            }
        }

        @Override
        public boolean check(String candidate, String encoded) throws OXException {
            if (Strings.isEmpty((String)candidate) && Strings.isEmpty((String)encoded)) {
                return true;
            }
            if (Strings.isEmpty((String)candidate) && Strings.isNotEmpty((String)encoded)) {
                return false;
            }
            if (Strings.isNotEmpty((String)candidate) && Strings.isEmpty((String)encoded)) {
                return false;
            }
            try {
                return UnixCrypt.matches(encoded, candidate);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("Error checking password according to CRYPT mechanism", (Throwable)e);
                throw PasswordMechExceptionCode.UNSUPPORTED_ENCODING.create(e, e.getMessage());
            }
        }
    }),
    SHA("{SHA}", new Encoder(){

        @Override
        public String encode(String str) throws OXException {
            try {
                return SHACrypt.makeSHAPasswd(str);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("Error encrypting password according to SHA mechanism", (Throwable)e);
                throw PasswordMechExceptionCode.UNSUPPORTED_ENCODING.create(e, e.getMessage());
            }
        }

        @Override
        public boolean check(String candidate, String encoded) throws OXException {
            if (Strings.isEmpty((String)candidate) && Strings.isEmpty((String)encoded)) {
                return true;
            }
            if (Strings.isEmpty((String)candidate) && Strings.isNotEmpty((String)encoded)) {
                return false;
            }
            if (Strings.isNotEmpty((String)candidate) && Strings.isEmpty((String)encoded)) {
                return false;
            }
            try {
                return SHACrypt.makeSHAPasswd(candidate).equals(encoded);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("Error checking password according to SHA mechanism", (Throwable)e);
                throw PasswordMechExceptionCode.UNSUPPORTED_ENCODING.create(e, e.getMessage());
            }
        }
    }),
    BCRYPT("{BCRYPT}", new Encoder(){

        @Override
        public String encode(String str) {
            return BCrypt.hashpw((String)str, (String)BCrypt.gensalt());
        }

        @Override
        public boolean check(String candidate, String encoded) {
            if (Strings.isEmpty((String)candidate) && Strings.isEmpty((String)encoded)) {
                return true;
            }
            if (Strings.isEmpty((String)candidate) && Strings.isNotEmpty((String)encoded)) {
                return false;
            }
            if (Strings.isNotEmpty((String)candidate) && Strings.isEmpty((String)encoded)) {
                return false;
            }
            return BCrypt.checkpw((String)candidate, (String)encoded);
        }
    });

    private static final Logger LOG;
    private final Encoder encoder;
    private final String identifier;

    private PasswordMech(String identifier, Encoder encoder) {
        this.identifier = identifier;
        this.encoder = encoder;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String encode(String str) throws OXException {
        if (null == str) {
            return null;
        }
        return this.encoder.encode(str);
    }

    @Override
    public boolean check(String toCheck, String encoded) throws OXException {
        return this.encoder.check(toCheck, encoded);
    }

    @Override
    public String decode(String encodedPassword) throws OXException {
        throw PasswordMechExceptionCode.UNSUPPORTED_OPERATION.create(this.getIdentifier());
    }

    static {
        LOG = LoggerFactory.getLogger(PasswordMech.class);
    }

    private static interface Encoder {
        public String encode(String var1) throws OXException;

        public boolean check(String var1, String var2) throws OXException;
    }
}

