/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.framework.request;

import com.openexchange.framework.request.RequestContext;
import com.openexchange.groupware.notify.hostname.HostData;

public class RequestContextHolder {
    private static final ThreadLocal<RequestContext> REQUEST_CONTEXT = new ThreadLocal();

    public static void set(RequestContext context) throws IllegalArgumentException {
        RequestContextHolder.validate(context);
        REQUEST_CONTEXT.set(context);
    }

    public static RequestContext get() {
        return REQUEST_CONTEXT.get();
    }

    public static RequestContext require() throws IllegalStateException {
        RequestContext requestContext = REQUEST_CONTEXT.get();
        if (requestContext == null) {
            throw new IllegalStateException("No request context exists for thread '" + Thread.currentThread().getName() + "'!");
        }
        return requestContext;
    }

    public static void reset() {
        REQUEST_CONTEXT.remove();
    }

    private static void validate(RequestContext context) throws IllegalArgumentException {
        if (context == null) {
            throw new IllegalArgumentException("Request context was null!");
        }
        RequestContextHolder.validateHostData(context.getHostData());
    }

    private static void validateHostData(HostData hostData) throws IllegalArgumentException {
        if (hostData == null) {
            throw new IllegalArgumentException("Host data was null!");
        }
        if (hostData.getHost() == null) {
            throw new IllegalArgumentException("Host name was null!");
        }
        if (hostData.getDispatcherPrefix() == null) {
            throw new IllegalArgumentException("Dispatcher servlet prefix was null!");
        }
        if (hostData.getRoute() == null) {
            throw new IllegalArgumentException("Route was null!");
        }
    }
}

