/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception.interception;

public class Responsibility {
    public static final String ALL = "*";
    public static final Responsibility RESPONSIBILITY_ALL = new Responsibility("*", "*");
    private final String module;
    private final String action;
    private final int hash;

    public Responsibility(String module, String action) {
        if (module == null) {
            throw new IllegalArgumentException("Module might not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Action might not be null");
        }
        this.module = module;
        this.action = action;
        this.hash = module.hashCode() ^ action.hashCode();
    }

    public String getModule() {
        return this.module;
    }

    public String getAction() {
        return this.action;
    }

    public boolean implies(Responsibility responsibility) {
        return this.implies(responsibility.module, responsibility.action);
    }

    public boolean implies(String module, String action) {
        if (null == module || null == action) {
            return false;
        }
        String thisModule = this.module;
        String thisAction = this.action;
        return !(!ALL.equals(thisModule) && !thisModule.equals(module) || !ALL.equals(thisAction) && !thisAction.equals(action));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Responsibility)) {
            return false;
        }
        Responsibility pairo = (Responsibility)o;
        return this.module.equals(pairo.getModule()) && this.action.equals(pairo.getAction());
    }

    public int hashCode() {
        return this.hash;
    }
}

