/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cli;

import java.util.List;

public class OutputHelper {
    private OutputHelper() {
    }

    public static void doOutput(String[] sizeAndAlignments, String[] names, List<List<String>> dataRows) {
        if (sizeAndAlignments.length != names.length) {
            throw new IllegalArgumentException("The sizes of columnsizes and columnnames aren't equal");
        }
        int[] columnsizes = new int[sizeAndAlignments.length];
        char[] alignments = new char[sizeAndAlignments.length];
        StringBuilder formatsb = new StringBuilder();
        char dividechar = ' ';
        for (int i = 0; i < sizeAndAlignments.length; ++i) {
            try {
                columnsizes[i] = Integer.parseInt(sizeAndAlignments[i].substring(0, sizeAndAlignments[i].length() - 1));
            }
            catch (NumberFormatException x) {
                columnsizes[i] = OutputHelper.longestLine(dataRows, names, i);
            }
            alignments[i] = sizeAndAlignments[i].charAt(sizeAndAlignments[i].length() - 1);
            if (names[i].length() > columnsizes[i]) {
                throw new IllegalArgumentException("Columnsize for column " + names[i] + " is too small for columnname");
            }
            formatsb.append("%");
            if (alignments[i] == 'l') {
                formatsb.append('-');
            }
            formatsb.append(columnsizes[i]);
            formatsb.append('s');
            formatsb.append(dividechar);
        }
        formatsb.deleteCharAt(formatsb.length() - 1);
        formatsb.append('\n');
        System.out.format(formatsb.toString(), names);
        for (List<String> row : dataRows) {
            if (row.size() != sizeAndAlignments.length) {
                throw new IllegalArgumentException("The size of one of the rows isn't correct");
            }
            Object[] outputrow = new Object[sizeAndAlignments.length];
            for (int i = 0; i < sizeAndAlignments.length; ++i) {
                String value = row.get(i);
                outputrow[i] = OutputHelper.stripString(value, columnsizes[i], "~");
            }
            System.out.format(formatsb.toString(), outputrow);
        }
    }

    private static String stripString(String text, int length, String lastmark) {
        if (null != text && text.length() > length) {
            int stringlength = length - lastmark.length();
            return new StringBuffer(text.substring(0, stringlength)).append(lastmark).toString();
        }
        if (text == null) {
            return "";
        }
        return text;
    }

    private static int longestLine(List<List<String>> data, String[] columnnames, int column) {
        int max = columnnames[column].length();
        for (int row = 0; row < data.size(); ++row) {
            int curLength;
            List<String> arrayList = data.get(row);
            if (columnnames.length != arrayList.size()) {
                throw new IllegalArgumentException("The sizes of columnnames and the columns in line " + row + " of the data aren't equal");
            }
            String value = arrayList.get(column);
            if (value == null || (curLength = arrayList.get(column).length()) <= max) continue;
            max = curLength;
        }
        return max;
    }
}

