/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cli;

import com.openexchange.cli.ExecutionFault;
import com.openexchange.cli.ReservedOptions;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public abstract class AbstractCLI<R, C> {
    protected Options options;

    protected AbstractCLI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R execute(String[] args) {
        String message;
        ReservedOptions options = this.newOptions();
        boolean error = true;
        try {
            options.addOption("h", "help", false, "Prints a help text");
            this.addOptions(options);
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse((Options)options, args);
            if (cmd.hasOption('h')) {
                this.printHelp(options);
                System.exit(0);
                R r = null;
                return r;
            }
            this.checkOptions(cmd, options);
            R retval = null;
            try {
                retval = this.invoke(options, cmd, null);
            }
            catch (Exception e) {
                Throwable t = e.getCause();
                throw new ExecutionFault(null == t ? e : t);
            }
            error = false;
            R r = retval;
            return r;
        }
        catch (ExecutionFault e) {
            Throwable t = e.getCause();
            String message2 = t.getMessage();
            System.err.println(null == message2 ? "An error occurred." : message2);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            this.printHelp(options);
        }
        catch (RuntimeException e) {
            message = e.getMessage();
            String clazzName = e.getClass().getName();
            System.err.println("A runtime error occurred: " + (null == message ? clazzName : clazzName + ": " + message));
        }
        catch (Throwable t) {
            message = t.getMessage();
            String clazzName = t.getClass().getName();
            System.err.println("A JVM problem occurred: " + (null == message ? clazzName : clazzName + ": " + message));
        }
        finally {
            if (error) {
                System.exit(1);
            }
        }
        return null;
    }

    protected abstract R invoke(Options var1, CommandLine var2, C var3) throws Exception;

    protected ReservedOptions newOptions() {
        ReservedOptions options = new ReservedOptions();
        this.options = options;
        return options;
    }

    protected abstract void addOptions(Options var1);

    protected void checkOptions(CommandLine cmd, Options options) {
        this.checkOptions(cmd);
    }

    protected abstract void checkOptions(CommandLine var1);

    protected void printHelp() {
        Options options = this.options;
        if (null != options) {
            this.printHelp(options);
        }
    }

    protected void printHelp(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(74, this.getName(), null, options, this.getFooter(), false);
    }

    protected abstract String getFooter();

    protected abstract String getName();

    protected int parsePort(char opt, int defaultValue, CommandLine cmd, Options options) {
        int port = defaultValue;
        String sPort = cmd.getOptionValue(opt);
        if (null != sPort) {
            try {
                port = Integer.parseInt(sPort.trim());
            }
            catch (NumberFormatException e) {
                System.err.println("Port parameter is not a number: " + sPort);
                this.printHelp(options);
                System.exit(1);
            }
        }
        if (port < 1 || port > 65535) {
            System.err.println("Port parameter is out of range: " + sPort + ". Valid range is from 1 to 65535.");
            this.printHelp(options);
            System.exit(1);
        }
        return port;
    }

    protected int parseInt(char opt, int defaultValue, CommandLine cmd, Options options) {
        int i = defaultValue;
        String sInt = cmd.getOptionValue(opt);
        if (null != sInt) {
            try {
                i = Integer.parseInt(sInt.trim());
            }
            catch (NumberFormatException e) {
                System.err.println("Integer parameter is not a number: " + sInt);
                this.printHelp(options);
                System.exit(1);
            }
        }
        return i;
    }

    protected int parseInt(String longOpt, int defaultValue, CommandLine cmd, Options options) {
        int i = defaultValue;
        String sInt = cmd.getOptionValue(longOpt);
        if (null != sInt) {
            try {
                i = Integer.parseInt(sInt.trim());
            }
            catch (NumberFormatException e) {
                System.err.println("Integer parameter is not a number: " + sInt);
                this.printHelp(options);
                System.exit(1);
            }
        }
        return i;
    }
}

