/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.session.reservation;

import com.openexchange.exception.OXException;
import com.openexchange.java.util.UUIDs;
import com.openexchange.session.reservation.Reservation;
import com.openexchange.session.reservation.SessionReservationService;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class SimSessionReservationService
implements SessionReservationService {
    private final ConcurrentMap<String, Reservation> reservations = new ConcurrentHashMap<String, Reservation>();

    public String reserveSessionFor(int userId, int contextId, long timeout, TimeUnit unit, Map<String, String> optState) throws OXException {
        String token = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        ReservationImpl reservationImpl = new ReservationImpl(token, userId, contextId, unit.toMillis(timeout), System.currentTimeMillis(), optState);
        this.reservations.put(token, reservationImpl);
        return token;
    }

    public Reservation removeReservation(String token) throws OXException {
        return (Reservation)this.reservations.remove(token);
    }

    private static class ReservationImpl
    implements Reservation {
        private final String token;
        private final int userId;
        private final int contextId;
        private final long timeoutMillis;
        private final long creationStamp;
        private final Map<String, String> state;

        public ReservationImpl(String token, int userId, int contextId, long timeoutMillis, long creationStamp, Map<String, String> state) {
            this.token = token;
            this.userId = userId;
            this.contextId = contextId;
            this.timeoutMillis = timeoutMillis;
            this.creationStamp = creationStamp;
            this.state = state;
        }

        public String getToken() {
            return this.token;
        }

        public int getUserId() {
            return this.userId;
        }

        public int getContextId() {
            return this.contextId;
        }

        public long getTimeoutMillis() {
            return this.timeoutMillis;
        }

        public long getCreationStamp() {
            return this.creationStamp;
        }

        public Map<String, String> getState() {
            return this.state;
        }
    }
}

