/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.FileActionTest;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.actions.files.UpdateAction;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateTest
extends FileActionTest {
    public void testMissingParameters() {
        try {
            this.action.handle((InfostoreRequest)this.request());
            UpdateTest.fail((String)"Expected Exception due to missing parameters");
        }
        catch (OXException x) {
            UpdateTest.assertTrue((boolean)true);
        }
    }

    public void testNoUpload() throws JSONException, OXException {
        this.request().param("timestamp", "1337").body(new JSONObject("{id: '23', folder_id: '12', title: 'nice title'}"));
        DefaultFile file = new DefaultFile();
        file.setId("23");
        file.setFolderId("12");
        file.setTitle("nice title");
        this.fileAccess().expectCall("saveFileMetadata", new Object[]{file, 1337L, Arrays.asList(File.Field.FOLDER_ID, File.Field.TITLE, File.Field.ID)});
        this.perform();
        this.fileAccess().assertAllWereCalled();
    }

    public void testMissingId() throws JSONException {
        this.request().param("timestamp", "1337").body(new JSONObject("{folder_id: '12', title: 'nice title'}"));
        try {
            this.action.handle((InfostoreRequest)this.request);
            UpdateTest.fail((String)"Expected Exception due to missing parameters");
        }
        catch (OXException x) {
            UpdateTest.assertTrue((boolean)true);
        }
    }

    public void testUpload() {
    }

    @Override
    public AbstractFileAction createAction() {
        return new UpdateAction();
    }
}

