/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.FileActionTest;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.actions.files.ListAction;
import com.openexchange.groupware.results.Results;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class ListTest
extends FileActionTest {
    public void testMissingParameters() {
        try {
            this.action.handle((InfostoreRequest)this.request());
            ListTest.fail((String)"Expected Exception due to missing parameters");
        }
        catch (OXException x) {
            ListTest.assertTrue((boolean)true);
        }
    }

    public void testAction() throws OXException, JSONException {
        this.request().param("columns", "1,700,702").param("timezone", "Europe/Berlin").body(new JSONArray("[{ folder: 'folder', id: 'id1'}, {folder: 'folder', id: 'id2'}]"));
        List<File.Field> columns = Arrays.asList(File.Field.ID, File.Field.TITLE, File.Field.FILENAME, File.Field.FOLDER_ID);
        this.fileAccess().expectCall("getDocuments", new Object[]{Arrays.asList("id1", "id2"), columns}).andReturn((Object)Results.emptyTimedResult());
        this.perform();
        this.fileAccess().assertAllWereCalled();
    }

    @Override
    public AbstractFileAction createAction() {
        return new ListAction();
    }
}

