/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageAccountManagerLookupService;
import com.openexchange.file.storage.FileStorageAccountManagerProvider;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.session.Session;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGIFileStorageAccountManagerLookupService
implements FileStorageAccountManagerLookupService {
    protected static final Object PRESENT = new Object();
    protected final ConcurrentMap<FileStorageAccountManagerProvider, Object> providers = new ConcurrentHashMap<FileStorageAccountManagerProvider, Object>(8, 0.9f, 1);
    protected volatile BundleContext bundleContext;
    private volatile ServiceTracker<FileStorageAccountManagerProvider, FileStorageAccountManagerProvider> tracker;
    private static final String PARAM_DEFAULT_ACCOUNT = "file.storage.defaultAccount";

    public void start(BundleContext context) {
        this.bundleContext = context;
        if (null == this.tracker) {
            ServiceTracker tracker = new ServiceTracker(context, FileStorageAccountManagerProvider.class, (ServiceTrackerCustomizer)new Customizer());
            tracker.open();
            this.tracker = tracker;
        }
    }

    public void stop() {
        ServiceTracker<FileStorageAccountManagerProvider, FileStorageAccountManagerProvider> tracker = this.tracker;
        if (null != tracker) {
            tracker.close();
            this.tracker = null;
        }
        this.bundleContext = null;
    }

    @Override
    public FileStorageAccountManager getAccountManager(String accountId, Session session) throws OXException {
        String paramName = PARAM_DEFAULT_ACCOUNT + '@' + accountId;
        FileStorageAccountManager accountManager = (FileStorageAccountManager)session.getParameter(paramName);
        if (null == accountManager) {
            FileStorageAccountManagerProvider candidate = null;
            for (FileStorageAccountManagerProvider provider : this.providers.keySet()) {
                FileStorageAccountManager cAccountManager;
                if (null != candidate && provider.getRanking() <= candidate.getRanking() || null == (cAccountManager = provider.getAccountManager(accountId, session))) continue;
                candidate = provider;
                accountManager = cAccountManager;
            }
            if (null == accountManager) {
                Logger logger = LoggerFactory.getLogger(OSGIFileStorageAccountManagerLookupService.class);
                String ls = System.getProperty("line.separator");
                logger.warn("{}    There is no file storage service available that provides account \"{}\".{}    Please ensure the appropriate {} is up and running.{}    Refer to /opt/open-xchange/sbin/listservices", new Object[]{ls, accountId, ls, FileStorageService.class.getSimpleName(), ls});
                return null;
            }
            session.setParameter(paramName, (Object)accountManager);
        }
        return accountManager;
    }

    @Override
    public FileStorageAccountManager getAccountManagerFor(String serviceId) throws OXException {
        if (null == serviceId) {
            String msg = "serviceId is null";
            throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create(new NullPointerException("serviceId is null"), "serviceId is null");
        }
        FileStorageAccountManagerProvider candidate = null;
        for (FileStorageAccountManagerProvider provider : this.providers.keySet()) {
            if (!provider.supports(serviceId) || null != candidate && provider.getRanking() <= candidate.getRanking()) continue;
            candidate = provider;
        }
        if (null == candidate) {
            throw FileStorageExceptionCodes.NO_ACCOUNT_MANAGER_FOR_SERVICE.create(serviceId);
        }
        return candidate.getAccountManagerFor(serviceId);
    }

    private final class Customizer
    implements ServiceTrackerCustomizer<FileStorageAccountManagerProvider, FileStorageAccountManagerProvider> {
        protected Customizer() {
        }

        public FileStorageAccountManagerProvider addingService(ServiceReference<FileStorageAccountManagerProvider> reference) {
            BundleContext context = OSGIFileStorageAccountManagerLookupService.this.bundleContext;
            FileStorageAccountManagerProvider service = (FileStorageAccountManagerProvider)context.getService(reference);
            if (null == OSGIFileStorageAccountManagerLookupService.this.providers.putIfAbsent(service, PRESENT)) {
                return service;
            }
            Logger logger = LoggerFactory.getLogger(Customizer.class);
            logger.warn(new StringBuilder(128).append("File storage account manager provider ").append(service.getClass().getSimpleName()).append(" could not be added. Provider is already present.").toString());
            context.ungetService(reference);
            return null;
        }

        public void modifiedService(ServiceReference<FileStorageAccountManagerProvider> reference, FileStorageAccountManagerProvider service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<FileStorageAccountManagerProvider> reference, FileStorageAccountManagerProvider service) {
            if (null != service) {
                try {
                    OSGIFileStorageAccountManagerLookupService.this.providers.remove(service);
                }
                finally {
                    OSGIFileStorageAccountManagerLookupService.this.bundleContext.ungetService(reference);
                }
            }
        }
    }
}

