/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageAccountManagerProvider;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.session.Session;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CompositeFileStorageAccountManagerProvider
implements FileStorageAccountManagerProvider {
    private static final Object PRESENT = new Object();
    private final ConcurrentMap<FileStorageAccountManagerProvider, Object> set = new ConcurrentHashMap<FileStorageAccountManagerProvider, Object>(4, 0.9f, 1);
    private volatile int ranking;
    private static final String PARAM_DEFAULT_ACCOUNT = "file.storage.compositeAccount";

    public boolean hasAnyProvider() {
        return !this.set.isEmpty();
    }

    public Collection<FileStorageAccountManagerProvider> providers() {
        return Collections.unmodifiableCollection(this.set.keySet());
    }

    public boolean addProvider(FileStorageAccountManagerProvider provider) {
        if (null == provider) {
            return false;
        }
        if (null != this.set.putIfAbsent(provider, PRESENT)) {
            return false;
        }
        this.ranking = Math.max(this.ranking, provider.getRanking());
        return true;
    }

    public void removeProvider(FileStorageAccountManagerProvider provider) {
        if (null == provider) {
            return;
        }
        if (null != this.set.remove(provider)) {
            int ranking = 0;
            for (FileStorageAccountManagerProvider p : this.set.keySet()) {
                int otherRanking = p.getRanking();
                if (otherRanking <= ranking) continue;
                ranking = otherRanking;
            }
            this.ranking = ranking;
        }
    }

    @Override
    public boolean supports(String serviceId) {
        for (FileStorageAccountManagerProvider provider : this.set.keySet()) {
            if (!provider.supports(serviceId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FileStorageAccountManager getAccountManager(String accountId, Session session) throws OXException {
        String paramName = PARAM_DEFAULT_ACCOUNT + '@' + accountId;
        FileStorageAccountManager accountManager = (FileStorageAccountManager)session.getParameter(paramName);
        if (null == accountManager) {
            FileStorageAccountManagerProvider candidate = null;
            for (FileStorageAccountManagerProvider provider : this.set.keySet()) {
                FileStorageAccountManager cAccountManager;
                if (null != candidate && provider.getRanking() <= candidate.getRanking() || null == (cAccountManager = provider.getAccountManager(accountId, session))) continue;
                candidate = provider;
                accountManager = cAccountManager;
            }
            if (null == accountManager) {
                return null;
            }
            session.setParameter(paramName, (Object)accountManager);
        }
        return accountManager;
    }

    @Override
    public FileStorageAccountManager getAccountManagerFor(String serviceId) throws OXException {
        FileStorageAccountManagerProvider candidate = null;
        for (FileStorageAccountManagerProvider provider : this.set.keySet()) {
            if (!provider.supports(serviceId) || null != candidate && candidate.getRanking() >= provider.getRanking()) continue;
            candidate = provider;
        }
        if (null == candidate) {
            throw FileStorageExceptionCodes.NO_ACCOUNT_MANAGER_FOR_SERVICE.create(serviceId);
        }
        return candidate.getAccountManagerFor(serviceId);
    }

    @Override
    public int getRanking() {
        return this.ranking;
    }
}

