/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.internal;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.ServiceAware;
import com.openexchange.file.storage.infostore.internal.InfostoreFileStorageService;
import com.openexchange.session.Session;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class InfostoreDefaultAccountManager
implements FileStorageAccountManager {
    public static final String DEFAULT_ID = "infostore";
    private final FileStorageAccount defaultAccount;

    public InfostoreDefaultAccountManager(InfostoreFileStorageService storageService) {
        this.defaultAccount = new FileStorageAccountImpl(storageService);
    }

    public String addAccount(FileStorageAccount account, Session session) throws OXException {
        return "";
    }

    public void deleteAccount(FileStorageAccount account, Session session) throws OXException {
    }

    public FileStorageAccount getAccount(String id, Session session) throws OXException {
        if (DEFAULT_ID.equals(id) || DEFAULT_ID.equals(id)) {
            return this.defaultAccount;
        }
        throw FileStorageExceptionCodes.ACCOUNT_NOT_FOUND.create(new Object[]{id, "com.openexchange.infostore"});
    }

    public List<FileStorageAccount> getAccounts(Session session) throws OXException {
        return Arrays.asList(this.defaultAccount);
    }

    public void migrateToNewSecret(String oldSecret, String newSecret, Session session) throws OXException {
    }

    public void cleanUp(String secret, Session session) throws OXException {
    }

    public void removeUnrecoverableItems(String secret, Session session) throws OXException {
    }

    public void updateAccount(FileStorageAccount account, Session session) throws OXException {
    }

    public boolean hasEncryptedItems(Session session) throws OXException {
        return false;
    }

    private static final class FileStorageAccountImpl
    implements FileStorageAccount,
    ServiceAware {
        private static final long serialVersionUID = -4701429514008282005L;
        private final InfostoreFileStorageService storageService;

        protected FileStorageAccountImpl(InfostoreFileStorageService storageService) {
            this.storageService = storageService;
        }

        public Map<String, Object> getConfiguration() {
            return Collections.emptyMap();
        }

        public String getDisplayName() {
            return "Standard Infostore";
        }

        public FileStorageService getFileStorageService() {
            return this.storageService;
        }

        public String getId() {
            return InfostoreDefaultAccountManager.DEFAULT_ID;
        }

        public String getServiceId() {
            return "com.openexchange.infostore";
        }
    }
}

