/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive;

public class DriveClientVersion
implements Comparable<DriveClientVersion> {
    public static final DriveClientVersion VERSION_0 = new DriveClientVersion("0");
    private final String version;
    private final int[] versionParts;

    public DriveClientVersion(String version) throws IllegalArgumentException {
        if (null == version || !version.matches("^[0-9]+(\\.[0-9]+)*$")) {
            throw new IllegalArgumentException(version);
        }
        this.version = version;
        String[] parts = version.split("\\.");
        this.versionParts = new int[parts.length];
        try {
            for (int i = 0; i < parts.length; ++i) {
                this.versionParts[i] = Integer.parseInt(parts[i]);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(version, e);
        }
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(DriveClientVersion other) {
        if (null == other) {
            return 1;
        }
        int maxLength = Math.max(this.versionParts.length, other.versionParts.length);
        for (int i = 0; i < maxLength; ++i) {
            int otherPart;
            int thisPart = i < this.versionParts.length ? this.versionParts[i] : 0;
            int n = otherPart = i < other.versionParts.length ? other.versionParts[i] : 0;
            if (thisPart < otherPart) {
                return -1;
            }
            if (thisPart <= otherPart) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.version;
    }
}

