/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.osgi;

import com.openexchange.config.cascade.ConfigProviderService;
import com.openexchange.config.cascade.ReinitializableConfigProviderService;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ConfigProviderTracker
implements ServiceTrackerCustomizer<ConfigProviderService, ConfigProviderService> {
    private final Queue<ReinitializableConfigProviderService> reinitQueue;
    private final BundleContext context;

    public ConfigProviderTracker(BundleContext context) {
        this.context = context;
        this.reinitQueue = new ConcurrentLinkedQueue<ReinitializableConfigProviderService>();
    }

    public ConfigProviderService addingService(ServiceReference<ConfigProviderService> reference) {
        ConfigProviderService providerService = (ConfigProviderService)this.context.getService(reference);
        if (providerService instanceof ReinitializableConfigProviderService) {
            this.reinitQueue.offer((ReinitializableConfigProviderService)providerService);
            return providerService;
        }
        this.context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference<ConfigProviderService> reference, ConfigProviderService service) {
    }

    public void removedService(ServiceReference<ConfigProviderService> reference, ConfigProviderService service) {
        this.reinitQueue.remove(service);
        this.context.ungetService(reference);
    }

    public Collection<ReinitializableConfigProviderService> getReinitQueue() {
        return Collections.unmodifiableCollection(this.reinitQueue);
    }
}

