/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.FolderTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bug4395Test
extends AppointmentTest {
    private static final Logger LOG = LoggerFactory.getLogger(Bug4395Test.class);
    private FolderObject folderObj = null;
    private int parentFolderId;

    public Bug4395Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.folderObj = null;
        this.parentFolderId = 0;
    }

    protected void tearDown() throws Exception {
        if (null != this.folderObj && 0 != this.parentFolderId) {
            FolderTest.deleteFolder(this.getSecondWebConversation(), new int[]{this.parentFolderId}, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
        }
        super.tearDown();
    }

    public void testBug4395() throws Exception {
        FolderObject sharedFolderObject = FolderTest.getAppointmentDefaultFolder(this.getSecondWebConversation(), "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
        int secondUserId = sharedFolderObject.getCreatedBy();
        this.folderObj = new FolderObject();
        this.folderObj.setFolderName("testBug4395" + System.currentTimeMillis());
        this.folderObj.setModule(2);
        this.folderObj.setType(1);
        this.folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(secondUserId, false, 128, 128, 128, 128, true)};
        this.folderObj.setPermissionsAsArray(permission);
        this.parentFolderId = FolderTest.insertFolder(this.getSecondWebConversation(), this.folderObj, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
        permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 128, 128, 128, 128, false), FolderTest.createPermission(secondUserId, false, 4, 128, 128, 128, true)};
        this.folderObj.setPermissionsAsArray(permission);
        this.folderObj.setObjectID(this.parentFolderId);
        FolderTest.updateFolder(this.getSecondWebConversation(), this.folderObj, this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug4395");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.parentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int appointmentObjectId = Bug4395Test.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(appointmentObjectId);
        Appointment loadAppointment = Bug4395Test.loadAppointment(this.getWebConversation(), appointmentObjectId, this.parentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug4395Test.compareObject(appointmentObj, loadAppointment);
        FolderTest.deleteFolder(this.getSecondWebConversation(), new int[]{this.parentFolderId}, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
        this.folderObj = null;
        this.parentFolderId = 0;
    }
}

