/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.IntrospectionTools;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Map;

public class Fixture<T> {
    private final T entry;
    private final String[] fields;
    private final Map<String, String> attributes;

    public Fixture(T entry, String[] fields, Map attributes) {
        this.entry = entry;
        this.fields = fields;
        this.attributes = attributes;
    }

    public boolean matches(T other) throws OXException {
        Class<?> klass = this.entry.getClass();
        for (String field : this.fields) {
            try {
                Method get = this.getMethod(field, klass);
                if (get == null) continue;
                Object v1 = get.invoke(this.entry, new Object[0]);
                Object v2 = get.invoke(other, new Object[0]);
                if (v1 == null && v2 != null) {
                    return false;
                }
                if (v1 != null && v2 == null) {
                    return false;
                }
                Comparator<Object> comp = this.getComparator(field);
                if (comp != null && comp.compare(v1, v2) != 0) {
                    return false;
                }
                if (comp != null || v1.equals(v2)) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new FixtureException(e);
            }
            catch (InvocationTargetException e) {
                throw new FixtureException(e);
            }
        }
        return true;
    }

    private Method getMethod(String field, Class<?> klass) throws OXException {
        for (Method m : klass.getMethods()) {
            if (!m.getName().equalsIgnoreCase(IntrospectionTools.getterName(field)) || m.getParameterTypes().length != 0) continue;
            return m;
        }
        return null;
    }

    public T getEntry() {
        return this.entry;
    }

    public Comparator<Object> getComparator(String field) {
        return null;
    }

    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }
}

