/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.mslive;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.subscribe.mslive.MSLiveSubscribeTestEnvironment;
import com.openexchange.test.ContactTestManager;
import com.openexchange.test.FolderTestManager;
import java.io.IOException;
import org.json.JSONException;

public class SubscribeMSLiveContactsTest
extends AbstractAJAXSession {
    protected static final String CONTACT_SOURCE_ID = "com.openexchange.subscribe.mslive.contact";
    private FolderTestManager folderMgr;
    private ContactTestManager contactMgr;

    public SubscribeMSLiveContactsTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folderMgr = new FolderTestManager(this.client);
        this.contactMgr = new ContactTestManager(this.client);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.folderMgr != null) {
            this.folderMgr.cleanUp();
        }
        super.tearDown();
    }

    private int getContactTestFolderID() {
        return this.getTestFolderID(CONTACT_SOURCE_ID);
    }

    private int getTestFolderID(String id) {
        return MSLiveSubscribeTestEnvironment.getInstance().getTestFolders().get(id);
    }

    public void testSubscribe() throws OXException, IOException, JSONException, Exception {
        Contact[] contacts = this.contactMgr.allAction(this.getContactTestFolderID(), Contact.ALL_COLUMNS);
        String testAccount1 = "Dr. Test Testerson";
        for (Contact c : contacts) {
            if (c.getDisplayName() == null || !c.getDisplayName().equals("Dr. Test Testerson")) continue;
            SubscribeMSLiveContactsTest.assertEquals((String)"given name", (String)"Test", (String)c.getGivenName());
            SubscribeMSLiveContactsTest.assertEquals((String)"sur_name", (String)"Testerson", (String)c.getSurName());
            SubscribeMSLiveContactsTest.assertEquals((String)"email1", (String)"invalid@home-private.com", (String)c.getEmail1());
            SubscribeMSLiveContactsTest.assertEquals((String)"email1", (String)"custom@custom.invalid", (String)c.getEmail2());
            SubscribeMSLiveContactsTest.assertEquals((String)"email1", (String)"test@invalid.org", (String)c.getEmail3());
        }
    }
}

