/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.Task;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import junit.framework.TestCase;

public class TaskAsserts
extends TestCase {
    public static void assertTaskFieldMatches(int field, Task expectedTask, Task comparedTask) {
        Mapper mapping = Mapping.getMapping((int)field);
        if (mapping == null) {
            return;
        }
        Object expectedValue = mapping.get(expectedTask);
        Object comparedValue = mapping.get(comparedTask);
        if (expectedValue instanceof Date) {
            TaskAsserts.assertTrue((String)("The following field should be equal in both Tasks: [" + TaskAsserts.getReadableName(mapping) + "], expected: " + expectedValue + ", but was: " + comparedValue), (boolean)TaskAsserts.checkOXDatesAreEqual((Date)expectedValue, (Date)comparedValue));
        } else {
            TaskAsserts.assertEquals((String)("The following field should be equal in both Tasks: [" + TaskAsserts.getReadableName(mapping) + "]"), (Object)expectedValue, (Object)comparedValue);
        }
    }

    private static String getReadableName(Mapper<?> mapping) {
        try {
            return mapping.getDBColumnName();
        }
        catch (UnsupportedOperationException x) {
            return mapping.getClass().getSimpleName();
        }
    }

    public static void assertTaskFieldDiffers(int field, Task expectedTask, Task comparedTask) {
        Mapper mapping = Mapping.getMapping((int)field);
        Object expectedValue = mapping.get(expectedTask);
        Object comparedValue = mapping.get(comparedTask);
        TaskAsserts.assertFalse((String)("The following field should differ in both Tasks: [" + mapping.getDBColumnName() + "]" + ", value: " + expectedValue), (boolean)expectedValue.equals(comparedValue));
    }

    public static void assertAllTaskFieldsMatchExcept(Task expectedTask, Task comparedTask, Set<Integer> excluded) {
        for (int column : Task.ALL_COLUMNS) {
            if (excluded.contains(column)) continue;
            TaskAsserts.assertTaskFieldMatches(column, expectedTask, comparedTask);
        }
    }

    public static void assertTaskFieldsDiffer(Task expectedTask, Task comparedTask, Set<Integer> included) {
        for (int column : Task.ALL_COLUMNS) {
            if (!included.contains(200)) continue;
            TaskAsserts.assertTaskFieldDiffers(column, expectedTask, comparedTask);
        }
    }

    public static void assertTaskIsInTheFuture(Task task) {
        Date now = new Date();
        TaskAsserts.assertTrue((String)"Start date not in the future", (now.compareTo(task.getStartDate()) < 0 ? 1 : 0) != 0);
        TaskAsserts.assertTrue((String)"End date not in the future", (now.compareTo(task.getStartDate()) < 0 ? 1 : 0) != 0);
    }

    public static void assertTaskIsInThePast(Task task) {
        Date now = new Date();
        TaskAsserts.assertTrue((String)"Start date not in the past", (now.compareTo(task.getStartDate()) > 0 ? 1 : 0) != 0);
        TaskAsserts.assertTrue((String)"End date not in the past", (now.compareTo(task.getStartDate()) > 0 ? 1 : 0) != 0);
    }

    public static void assertTaskIsOngoing(Task task) {
        Date now = new Date();
        TaskAsserts.assertTrue((String)"Start date not in the past", (now.compareTo(task.getStartDate()) > 0 ? 1 : 0) != 0);
        TaskAsserts.assertTrue((String)"End date not in the future", (now.compareTo(task.getStartDate()) < 0 ? 1 : 0) != 0);
    }

    public static void assertFirstDateOccursLaterThanSecond(Date firstDate, Date secondDate) {
        TaskAsserts.assertTrue((firstDate.compareTo(secondDate) > 0 ? 1 : 0) != 0);
    }

    public static void assertFirstDateOccursEarlierThanSecond(Date firstDate, Date secondDate) {
        TaskAsserts.assertTrue((firstDate.compareTo(secondDate) < 0 ? 1 : 0) != 0);
    }

    public static boolean checkOXDatesAreEqual(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        cal1.set(14, 0);
        cal2.set(14, 0);
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5) && cal1.get(11) == cal2.get(11) && cal1.get(12) == cal2.get(12);
    }

    public static void assertDateInRecurrence(Date date, CalendarObject calendarObject) {
        TaskAsserts.fail((String)"NOT IMPLEMENTED");
    }
}

