/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import com.openexchange.groupware.container.CalendarObject;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Bug12571Test
extends CalendarSqlTest {
    public void testProperOccurrencesOfYearlyApp() {
        try {
            RecurringResultInterface result;
            int i;
            CalendarDataObject appointment = this.appointments.buildBasicAppointment(CommonAppointments.D("01/11/2008 12:00"), CommonAppointments.D("01/11/2008 13:00"));
            appointment.setTitle("Test for bug #12571");
            appointment.setFullTime(false);
            appointment.setRecurrenceType(4);
            appointment.setInterval(1);
            appointment.setDays(127);
            appointment.setDayInMonth(1);
            appointment.setMonth(10);
            appointment.setOccurrence(10);
            this.appointments.save(appointment);
            this.clean.add(appointment);
            CalendarDataObject reloaded = this.appointments.reload(appointment);
            RecurringResultsInterface results = this.getTools().calculateRecurring((CalendarObject)reloaded, 0L, 0L, 0);
            int size = results.size();
            Bug12571Test.assertEquals((String)"Unexpected number of recurring results", (int)10, (int)size);
            Calendar checker = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
            checker.setTimeInMillis(reloaded.getStartDate().getTime());
            int year = checker.get(1);
            for (i = 0; i < size; ++i) {
                result = results.getRecurringResult(i);
                checker.setTimeInMillis(result.getStart());
                Bug12571Test.assertEquals((String)("Unexpected day-of-month in " + (i + 1) + ". occurrence"), (int)1, (int)checker.get(5));
                Bug12571Test.assertEquals((String)("Unexpected month in " + (i + 1) + ". occurrence"), (int)10, (int)checker.get(2));
                Bug12571Test.assertEquals((String)("Unexpected year in " + (i + 1) + ". occurrence"), (int)year++, (int)checker.get(1));
            }
            appointment = this.appointments.buildBasicAppointment(CommonAppointments.D("01/04/2008 12:00"), CommonAppointments.D("01/04/2008 13:00"));
            appointment.setTitle("Test for bug #12571");
            appointment.setFullTime(false);
            appointment.setRecurrenceType(4);
            appointment.setInterval(1);
            appointment.setDays(4);
            appointment.setDayInMonth(1);
            appointment.setMonth(3);
            appointment.setOccurrence(10);
            this.appointments.save(appointment);
            this.clean.add(appointment);
            reloaded = this.appointments.reload(appointment);
            results = this.getTools().calculateRecurring((CalendarObject)reloaded, 0L, 0L, 0);
            size = results.size();
            Bug12571Test.assertEquals((String)"Unexpected number of recurring results", (int)10, (int)size);
            checker = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
            checker.setTimeInMillis(reloaded.getStartDate().getTime());
            year = checker.get(1);
            for (i = 0; i < size; ++i) {
                result = results.getRecurringResult(i);
                checker.setTimeInMillis(result.getStart());
                Bug12571Test.assertEquals((String)("Unexpected day-of-week in " + (i + 1) + ". occurrence"), (int)3, (int)checker.get(7));
                Bug12571Test.assertEquals((String)("Unexpected month in " + (i + 1) + ". occurrence"), (int)3, (int)checker.get(2));
                Bug12571Test.assertEquals((String)("Unexpected year in " + (i + 1) + ". occurrence"), (int)year++, (int)checker.get(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug12571Test.fail((String)e.getMessage());
        }
    }
}

