/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.List;
import java.util.Map;
import net.sourceforge.cardme.vcard.types.AdrType;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.Test;

public class Bug40471Test
extends CardDAVTest {
    @Test
    public void testContentTypeInGet() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug40471Test.randomUID();
        String firstName = "S\u00f6ren";
        String lastName = "S\u00fc\u00df";
        String country = "\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setCountryBusiness(country);
        contact.setUid(uid);
        this.rememberForCleanUp(this.create(contact));
        Map<String, String> eTags = this.syncCollection(syncToken);
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = this.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug40471Test.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)card.getFN());
        Assert.assertEquals((String)"Country wrong", (Object)country, (Object)((AdrType)card.getVCard().getAdrs().get(0)).getCountryName());
        String href = card.getHref();
        GetMethod get = new GetMethod(this.getWebDAVClient().getBaseURI() + href);
        String vCard = this.getWebDAVClient().doGet(get);
        Assert.assertNotNull((Object)vCard);
        card = new VCardResource(vCard, href, null);
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)card.getFN());
        Assert.assertEquals((String)"Country wrong", (Object)country, (Object)((AdrType)card.getVCard().getAdrs().get(0)).getCountryName());
    }
}

