/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class Bug21354Test
extends CardDAVTest {
    @Test
    public void testDeleteFromGAB_10_6() throws Exception {
        super.getWebDAVClient().setUserAgent("Address%20Book/883 CFNetwork/454.12.4 Darwin/10.8.0 (i386)");
        Map<String, String> eTags = super.getAllETags();
        String cTag = super.getCTag();
        List<Contact> contacts = super.getContacts(super.getGABFolderID());
        String uid = contacts.get(new Random().nextInt(contacts.size())).getUid();
        super.removeFromETags(eTags, uid);
        Assert.assertEquals((String)"response code wrong", (long)200L, (long)super.delete(uid));
        Assert.assertNotNull((String)"Contact deleted on server", (Object)super.getContact(uid));
        String cTag2 = super.getCTag();
        Assert.assertFalse((String)"No changes indicated by CTag", (boolean)cTag.equals(cTag2));
        Map<String, String> eTags2 = super.getAllETags();
        List<String> changedHrefs = super.getChangedHrefs(eTags, eTags2);
        Assert.assertTrue((String)"less than 1 change reported in Etags", (0 < changedHrefs.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(changedHrefs);
        Bug21354Test.assertContains(uid, addressData);
    }

    @Test
    public void testDeleteFromGAB_10_7() throws Exception {
        super.getWebDAVClient().setUserAgent("AddressBook/6.1 (1062) CardDAVPlugin/196 CFNetwork/520.2.5 Mac_OS_X/10.7.2 (11C74)");
        Map<String, String> eTags = super.getAllETags();
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        List<Contact> contacts = super.getContacts(super.getGABFolderID());
        String uid = contacts.get(new Random().nextInt(contacts.size())).getUid();
        super.removeFromETags(eTags, uid);
        Assert.assertEquals((String)"response code wrong", (long)200L, (long)super.delete(uid));
        Assert.assertNotNull((String)"Contact deleted on server", (Object)super.getContact(uid));
        Map<String, String> eTags2 = super.syncCollection(syncToken).getETagsStatusOK();
        List<String> changedHrefs = super.getChangedHrefs(eTags, eTags2);
        Assert.assertTrue((String)"less than 1 change reported in Etags", (0 < changedHrefs.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(changedHrefs);
        Bug21354Test.assertContains(uid, addressData);
    }
}

